<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response
 * StructType
 * @subpackage Structs
 */
class S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Room[]
     */
    public $Room;
    /**
     * Constructor method for S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response
     * @uses S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response::setResult()
     * @uses S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response::setTransactionID()
     * @uses S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response::setRoom()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Room[] $room
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $room = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setRoom($room);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003ResponseRoomItem) {
            // validation for constraint: itemType
            if (!$s_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003ResponseRoomItem instanceof \StructType\Room) {
                $invalidValues[] = is_object($s_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003ResponseRoomItem) ? get_class($s_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003ResponseRoomItem) : sprintf('%s(%s)', gettype($s_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003ResponseRoomItem), var_export($s_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003ResponseRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room[] $room
     * @return \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room $item
     * @return \StructType\S_ROOM_MAINTENANCE_STATE_WITHOUT_IMAGE_GET_V003Response
     */
    public function addToRoom(\StructType\Room $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Room) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
}
