<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RESERVATION_SEARCH_V003Request StructType
 * @subpackage Structs
 */
class S_RESERVATION_SEARCH_V003Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The RESERVATIONSEARCH
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RESERVATIONSEARCH_1
     */
    public $RESERVATIONSEARCH;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_RESERVATION_SEARCH_V003Request
     * @uses S_RESERVATION_SEARCH_V003Request::setAuthentication()
     * @uses S_RESERVATION_SEARCH_V003Request::setRESERVATIONSEARCH()
     * @uses S_RESERVATION_SEARCH_V003Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\RESERVATIONSEARCH_1 $rESERVATIONSEARCH
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\RESERVATIONSEARCH_1 $rESERVATIONSEARCH = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setRESERVATIONSEARCH($rESERVATIONSEARCH)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_RESERVATION_SEARCH_V003Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get RESERVATIONSEARCH value
     * @return \StructType\RESERVATIONSEARCH_1
     */
    public function getRESERVATIONSEARCH()
    {
        return $this->RESERVATIONSEARCH;
    }
    /**
     * Set RESERVATIONSEARCH value
     * @param \StructType\RESERVATIONSEARCH_1 $rESERVATIONSEARCH
     * @return \StructType\S_RESERVATION_SEARCH_V003Request
     */
    public function setRESERVATIONSEARCH(\StructType\RESERVATIONSEARCH_1 $rESERVATIONSEARCH = null)
    {
        $this->RESERVATIONSEARCH = $rESERVATIONSEARCH;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RESERVATION_SEARCH_V003Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
