<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RESERVATION_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_RESERVATION_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ReservationSearchEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReservationSearchEntry[]
     */
    public $ReservationSearchEntry;
    /**
     * Constructor method for S_RESERVATION_SEARCH_V001Response
     * @uses S_RESERVATION_SEARCH_V001Response::setResult()
     * @uses S_RESERVATION_SEARCH_V001Response::setTransactionID()
     * @uses S_RESERVATION_SEARCH_V001Response::setReservationSearchEntry()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\ReservationSearchEntry[] $reservationSearchEntry
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $reservationSearchEntry = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setReservationSearchEntry($reservationSearchEntry);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_RESERVATION_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RESERVATION_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ReservationSearchEntry value
     * @return \StructType\ReservationSearchEntry[]|null
     */
    public function getReservationSearchEntry()
    {
        return $this->ReservationSearchEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setReservationSearchEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservationSearchEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationSearchEntryForArrayConstraintsFromSetReservationSearchEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_RESERVATION_SEARCH_V001ResponseReservationSearchEntryItem) {
            // validation for constraint: itemType
            if (!$s_RESERVATION_SEARCH_V001ResponseReservationSearchEntryItem instanceof \StructType\ReservationSearchEntry) {
                $invalidValues[] = is_object($s_RESERVATION_SEARCH_V001ResponseReservationSearchEntryItem) ? get_class($s_RESERVATION_SEARCH_V001ResponseReservationSearchEntryItem) : sprintf('%s(%s)', gettype($s_RESERVATION_SEARCH_V001ResponseReservationSearchEntryItem), var_export($s_RESERVATION_SEARCH_V001ResponseReservationSearchEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReservationSearchEntry property can only contain items of type \StructType\ReservationSearchEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReservationSearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ReservationSearchEntry[] $reservationSearchEntry
     * @return \StructType\S_RESERVATION_SEARCH_V001Response
     */
    public function setReservationSearchEntry(array $reservationSearchEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationSearchEntryArrayErrorMessage = self::validateReservationSearchEntryForArrayConstraintsFromSetReservationSearchEntry($reservationSearchEntry))) {
            throw new \InvalidArgumentException($reservationSearchEntryArrayErrorMessage, __LINE__);
        }
        $this->ReservationSearchEntry = $reservationSearchEntry;
        return $this;
    }
    /**
     * Add item to ReservationSearchEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ReservationSearchEntry $item
     * @return \StructType\S_RESERVATION_SEARCH_V001Response
     */
    public function addToReservationSearchEntry(\StructType\ReservationSearchEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReservationSearchEntry) {
            throw new \InvalidArgumentException(sprintf('The ReservationSearchEntry property can only contain items of type \StructType\ReservationSearchEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReservationSearchEntry[] = $item;
        return $this;
    }
}
