<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RESERVATION_GROUP_RESERVATION_ADD_V001Response
 * StructType
 * @subpackage Structs
 */
class S_RESERVATION_GROUP_RESERVATION_ADD_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ResNewGroupReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ResNewGroupReservation[]
     */
    public $ResNewGroupReservation;
    /**
     * Constructor method for S_RESERVATION_GROUP_RESERVATION_ADD_V001Response
     * @uses S_RESERVATION_GROUP_RESERVATION_ADD_V001Response::setResult()
     * @uses S_RESERVATION_GROUP_RESERVATION_ADD_V001Response::setTransactionID()
     * @uses S_RESERVATION_GROUP_RESERVATION_ADD_V001Response::setResNewGroupReservation()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\ResNewGroupReservation[] $resNewGroupReservation
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $resNewGroupReservation = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setResNewGroupReservation($resNewGroupReservation);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ResNewGroupReservation value
     * @return \StructType\ResNewGroupReservation[]|null
     */
    public function getResNewGroupReservation()
    {
        return $this->ResNewGroupReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setResNewGroupReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResNewGroupReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResNewGroupReservationForArrayConstraintsFromSetResNewGroupReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_RESERVATION_GROUP_RESERVATION_ADD_V001ResponseResNewGroupReservationItem) {
            // validation for constraint: itemType
            if (!$s_RESERVATION_GROUP_RESERVATION_ADD_V001ResponseResNewGroupReservationItem instanceof \StructType\ResNewGroupReservation) {
                $invalidValues[] = is_object($s_RESERVATION_GROUP_RESERVATION_ADD_V001ResponseResNewGroupReservationItem) ? get_class($s_RESERVATION_GROUP_RESERVATION_ADD_V001ResponseResNewGroupReservationItem) : sprintf('%s(%s)', gettype($s_RESERVATION_GROUP_RESERVATION_ADD_V001ResponseResNewGroupReservationItem), var_export($s_RESERVATION_GROUP_RESERVATION_ADD_V001ResponseResNewGroupReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResNewGroupReservation property can only contain items of type \StructType\ResNewGroupReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResNewGroupReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\ResNewGroupReservation[] $resNewGroupReservation
     * @return \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V001Response
     */
    public function setResNewGroupReservation(array $resNewGroupReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($resNewGroupReservationArrayErrorMessage = self::validateResNewGroupReservationForArrayConstraintsFromSetResNewGroupReservation($resNewGroupReservation))) {
            throw new \InvalidArgumentException($resNewGroupReservationArrayErrorMessage, __LINE__);
        }
        $this->ResNewGroupReservation = $resNewGroupReservation;
        return $this;
    }
    /**
     * Add item to ResNewGroupReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\ResNewGroupReservation $item
     * @return \StructType\S_RESERVATION_GROUP_RESERVATION_ADD_V001Response
     */
    public function addToResNewGroupReservation(\StructType\ResNewGroupReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResNewGroupReservation) {
            throw new \InvalidArgumentException(sprintf('The ResNewGroupReservation property can only contain items of type \StructType\ResNewGroupReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResNewGroupReservation[] = $item;
        return $this;
    }
}
