<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RESERVATION_GET_V006Request StructType
 * @subpackage Structs
 */
class S_RESERVATION_GET_V006Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The RESERVATION
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RESERVATION
     */
    public $RESERVATION;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_RESERVATION_GET_V006Request
     * @uses S_RESERVATION_GET_V006Request::setAuthentication()
     * @uses S_RESERVATION_GET_V006Request::setRESERVATION()
     * @uses S_RESERVATION_GET_V006Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\RESERVATION $rESERVATION
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\RESERVATION $rESERVATION = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setRESERVATION($rESERVATION)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_RESERVATION_GET_V006Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get RESERVATION value
     * @return \StructType\RESERVATION
     */
    public function getRESERVATION()
    {
        return $this->RESERVATION;
    }
    /**
     * Set RESERVATION value
     * @param \StructType\RESERVATION $rESERVATION
     * @return \StructType\S_RESERVATION_GET_V006Request
     */
    public function setRESERVATION(\StructType\RESERVATION $rESERVATION = null)
    {
        $this->RESERVATION = $rESERVATION;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RESERVATION_GET_V006Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
