<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_REGISTRATIONCARD_GET_V002Response StructType
 * @subpackage Structs
 */
class S_REGISTRATIONCARD_GET_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The RegistrationCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegistrationCard[]
     */
    public $RegistrationCard;
    /**
     * Constructor method for S_REGISTRATIONCARD_GET_V002Response
     * @uses S_REGISTRATIONCARD_GET_V002Response::setResult()
     * @uses S_REGISTRATIONCARD_GET_V002Response::setTransactionID()
     * @uses S_REGISTRATIONCARD_GET_V002Response::setRegistrationCard()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\RegistrationCard[] $registrationCard
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $registrationCard = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setRegistrationCard($registrationCard);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_REGISTRATIONCARD_GET_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_REGISTRATIONCARD_GET_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get RegistrationCard value
     * @return \StructType\RegistrationCard[]|null
     */
    public function getRegistrationCard()
    {
        return $this->RegistrationCard;
    }
    /**
     * This method is responsible for validating the values passed to the setRegistrationCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegistrationCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegistrationCardForArrayConstraintsFromSetRegistrationCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_REGISTRATIONCARD_GET_V002ResponseRegistrationCardItem) {
            // validation for constraint: itemType
            if (!$s_REGISTRATIONCARD_GET_V002ResponseRegistrationCardItem instanceof \StructType\RegistrationCard) {
                $invalidValues[] = is_object($s_REGISTRATIONCARD_GET_V002ResponseRegistrationCardItem) ? get_class($s_REGISTRATIONCARD_GET_V002ResponseRegistrationCardItem) : sprintf('%s(%s)', gettype($s_REGISTRATIONCARD_GET_V002ResponseRegistrationCardItem), var_export($s_REGISTRATIONCARD_GET_V002ResponseRegistrationCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RegistrationCard property can only contain items of type \StructType\RegistrationCard, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RegistrationCard value
     * @throws \InvalidArgumentException
     * @param \StructType\RegistrationCard[] $registrationCard
     * @return \StructType\S_REGISTRATIONCARD_GET_V002Response
     */
    public function setRegistrationCard(array $registrationCard = array())
    {
        // validation for constraint: array
        if ('' !== ($registrationCardArrayErrorMessage = self::validateRegistrationCardForArrayConstraintsFromSetRegistrationCard($registrationCard))) {
            throw new \InvalidArgumentException($registrationCardArrayErrorMessage, __LINE__);
        }
        $this->RegistrationCard = $registrationCard;
        return $this;
    }
    /**
     * Add item to RegistrationCard value
     * @throws \InvalidArgumentException
     * @param \StructType\RegistrationCard $item
     * @return \StructType\S_REGISTRATIONCARD_GET_V002Response
     */
    public function addToRegistrationCard(\StructType\RegistrationCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegistrationCard) {
            throw new \InvalidArgumentException(sprintf('The RegistrationCard property can only contain items of type \StructType\RegistrationCard, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RegistrationCard[] = $item;
        return $this;
    }
}
