<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_RATE_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_RATE_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The RATERESULT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RATERESULT[]
     */
    public $RATERESULT;
    /**
     * Constructor method for S_RATE_SEARCH_V001Response
     * @uses S_RATE_SEARCH_V001Response::setResult()
     * @uses S_RATE_SEARCH_V001Response::setTransactionID()
     * @uses S_RATE_SEARCH_V001Response::setRATERESULT()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\RATERESULT[] $rATERESULT
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $rATERESULT = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setRATERESULT($rATERESULT);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_RATE_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_RATE_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get RATERESULT value
     * @return \StructType\RATERESULT[]|null
     */
    public function getRATERESULT()
    {
        return $this->RATERESULT;
    }
    /**
     * This method is responsible for validating the values passed to the setRATERESULT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRATERESULT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRATERESULTForArrayConstraintsFromSetRATERESULT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_RATE_SEARCH_V001ResponseRATERESULTItem) {
            // validation for constraint: itemType
            if (!$s_RATE_SEARCH_V001ResponseRATERESULTItem instanceof \StructType\RATERESULT) {
                $invalidValues[] = is_object($s_RATE_SEARCH_V001ResponseRATERESULTItem) ? get_class($s_RATE_SEARCH_V001ResponseRATERESULTItem) : sprintf('%s(%s)', gettype($s_RATE_SEARCH_V001ResponseRATERESULTItem), var_export($s_RATE_SEARCH_V001ResponseRATERESULTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RATERESULT property can only contain items of type \StructType\RATERESULT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RATERESULT value
     * @throws \InvalidArgumentException
     * @param \StructType\RATERESULT[] $rATERESULT
     * @return \StructType\S_RATE_SEARCH_V001Response
     */
    public function setRATERESULT(array $rATERESULT = array())
    {
        // validation for constraint: array
        if ('' !== ($rATERESULTArrayErrorMessage = self::validateRATERESULTForArrayConstraintsFromSetRATERESULT($rATERESULT))) {
            throw new \InvalidArgumentException($rATERESULTArrayErrorMessage, __LINE__);
        }
        $this->RATERESULT = $rATERESULT;
        return $this;
    }
    /**
     * Add item to RATERESULT value
     * @throws \InvalidArgumentException
     * @param \StructType\RATERESULT $item
     * @return \StructType\S_RATE_SEARCH_V001Response
     */
    public function addToRATERESULT(\StructType\RATERESULT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RATERESULT) {
            throw new \InvalidArgumentException(sprintf('The RATERESULT property can only contain items of type \StructType\RATERESULT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RATERESULT[] = $item;
        return $this;
    }
}
