<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PRODUCT_FEATURES_GET_V001Request StructType
 * @subpackage Structs
 */
class S_PRODUCT_FEATURES_GET_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The PRODUCT_FEATURES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PRODUCT_FEATURES
     */
    public $PRODUCT_FEATURES;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_PRODUCT_FEATURES_GET_V001Request
     * @uses S_PRODUCT_FEATURES_GET_V001Request::setAuthentication()
     * @uses S_PRODUCT_FEATURES_GET_V001Request::setPRODUCT_FEATURES()
     * @uses S_PRODUCT_FEATURES_GET_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\PRODUCT_FEATURES $pRODUCT_FEATURES
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\PRODUCT_FEATURES $pRODUCT_FEATURES = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPRODUCT_FEATURES($pRODUCT_FEATURES)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get PRODUCT_FEATURES value
     * @return \StructType\PRODUCT_FEATURES
     */
    public function getPRODUCT_FEATURES()
    {
        return $this->{'PRODUCT-FEATURES'};
    }
    /**
     * Set PRODUCT_FEATURES value
     * @param \StructType\PRODUCT_FEATURES $pRODUCT_FEATURES
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Request
     */
    public function setPRODUCT_FEATURES(\StructType\PRODUCT_FEATURES $pRODUCT_FEATURES = null)
    {
        $this->PRODUCT_FEATURES = $this->{'PRODUCT-FEATURES'} = $pRODUCT_FEATURES;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PRODUCT_FEATURES_GET_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
