<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PERSON_SERVICE_REMOVE_V001Request StructType
 * @subpackage Structs
 */
class S_PERSON_SERVICE_REMOVE_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The PersonSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonSearch
     */
    public $PersonSearch;
    /**
     * The ServiceToRemove
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceToRemove
     */
    public $ServiceToRemove;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_PERSON_SERVICE_REMOVE_V001Request
     * @uses S_PERSON_SERVICE_REMOVE_V001Request::setAuthentication()
     * @uses S_PERSON_SERVICE_REMOVE_V001Request::setPersonSearch()
     * @uses S_PERSON_SERVICE_REMOVE_V001Request::setServiceToRemove()
     * @uses S_PERSON_SERVICE_REMOVE_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\PersonSearch $personSearch
     * @param \StructType\ServiceToRemove $serviceToRemove
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\PersonSearch $personSearch = null, \StructType\ServiceToRemove $serviceToRemove = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPersonSearch($personSearch)
            ->setServiceToRemove($serviceToRemove)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_PERSON_SERVICE_REMOVE_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get PersonSearch value
     * @return \StructType\PersonSearch
     */
    public function getPersonSearch()
    {
        return $this->PersonSearch;
    }
    /**
     * Set PersonSearch value
     * @param \StructType\PersonSearch $personSearch
     * @return \StructType\S_PERSON_SERVICE_REMOVE_V001Request
     */
    public function setPersonSearch(\StructType\PersonSearch $personSearch = null)
    {
        $this->PersonSearch = $personSearch;
        return $this;
    }
    /**
     * Get ServiceToRemove value
     * @return \StructType\ServiceToRemove
     */
    public function getServiceToRemove()
    {
        return $this->ServiceToRemove;
    }
    /**
     * Set ServiceToRemove value
     * @param \StructType\ServiceToRemove $serviceToRemove
     * @return \StructType\S_PERSON_SERVICE_REMOVE_V001Request
     */
    public function setServiceToRemove(\StructType\ServiceToRemove $serviceToRemove = null)
    {
        $this->ServiceToRemove = $serviceToRemove;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PERSON_SERVICE_REMOVE_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
