<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_PERSON_SERVICE_MODIFY_V001Request StructType
 * @subpackage Structs
 */
class S_PERSON_SERVICE_MODIFY_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The PERSON_SERVICE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PERSON_SERVICE
     */
    public $PERSON_SERVICE;
    /**
     * The SERVICE_DATA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SERVICE_DATA
     */
    public $SERVICE_DATA;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_PERSON_SERVICE_MODIFY_V001Request
     * @uses S_PERSON_SERVICE_MODIFY_V001Request::setAuthentication()
     * @uses S_PERSON_SERVICE_MODIFY_V001Request::setPERSON_SERVICE()
     * @uses S_PERSON_SERVICE_MODIFY_V001Request::setSERVICE_DATA()
     * @uses S_PERSON_SERVICE_MODIFY_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\PERSON_SERVICE $pERSON_SERVICE
     * @param \StructType\SERVICE_DATA $sERVICE_DATA
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\PERSON_SERVICE $pERSON_SERVICE = null, \StructType\SERVICE_DATA $sERVICE_DATA = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPERSON_SERVICE($pERSON_SERVICE)
            ->setSERVICE_DATA($sERVICE_DATA)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_PERSON_SERVICE_MODIFY_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get PERSON_SERVICE value
     * @return \StructType\PERSON_SERVICE
     */
    public function getPERSON_SERVICE()
    {
        return $this->{'PERSON-SERVICE'};
    }
    /**
     * Set PERSON_SERVICE value
     * @param \StructType\PERSON_SERVICE $pERSON_SERVICE
     * @return \StructType\S_PERSON_SERVICE_MODIFY_V001Request
     */
    public function setPERSON_SERVICE(\StructType\PERSON_SERVICE $pERSON_SERVICE = null)
    {
        $this->PERSON_SERVICE = $this->{'PERSON-SERVICE'} = $pERSON_SERVICE;
        return $this;
    }
    /**
     * Get SERVICE_DATA value
     * @return \StructType\SERVICE_DATA
     */
    public function getSERVICE_DATA()
    {
        return $this->{'SERVICE-DATA'};
    }
    /**
     * Set SERVICE_DATA value
     * @param \StructType\SERVICE_DATA $sERVICE_DATA
     * @return \StructType\S_PERSON_SERVICE_MODIFY_V001Request
     */
    public function setSERVICE_DATA(\StructType\SERVICE_DATA $sERVICE_DATA = null)
    {
        $this->SERVICE_DATA = $this->{'SERVICE-DATA'} = $sERVICE_DATA;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_PERSON_SERVICE_MODIFY_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
