<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_NOTIFICATION_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_NOTIFICATION_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The NOTIFICATIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NOTIFICATIONS[]
     */
    public $NOTIFICATIONS;
    /**
     * Constructor method for S_NOTIFICATION_SEARCH_V001Response
     * @uses S_NOTIFICATION_SEARCH_V001Response::setResult()
     * @uses S_NOTIFICATION_SEARCH_V001Response::setTransactionID()
     * @uses S_NOTIFICATION_SEARCH_V001Response::setNOTIFICATIONS()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\NOTIFICATIONS[] $nOTIFICATIONS
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $nOTIFICATIONS = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setNOTIFICATIONS($nOTIFICATIONS);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_NOTIFICATION_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_NOTIFICATION_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get NOTIFICATIONS value
     * @return \StructType\NOTIFICATIONS[]|null
     */
    public function getNOTIFICATIONS()
    {
        return $this->NOTIFICATIONS;
    }
    /**
     * This method is responsible for validating the values passed to the setNOTIFICATIONS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNOTIFICATIONS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNOTIFICATIONSForArrayConstraintsFromSetNOTIFICATIONS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_NOTIFICATION_SEARCH_V001ResponseNOTIFICATIONSItem) {
            // validation for constraint: itemType
            if (!$s_NOTIFICATION_SEARCH_V001ResponseNOTIFICATIONSItem instanceof \StructType\NOTIFICATIONS) {
                $invalidValues[] = is_object($s_NOTIFICATION_SEARCH_V001ResponseNOTIFICATIONSItem) ? get_class($s_NOTIFICATION_SEARCH_V001ResponseNOTIFICATIONSItem) : sprintf('%s(%s)', gettype($s_NOTIFICATION_SEARCH_V001ResponseNOTIFICATIONSItem), var_export($s_NOTIFICATION_SEARCH_V001ResponseNOTIFICATIONSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NOTIFICATIONS property can only contain items of type \StructType\NOTIFICATIONS, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NOTIFICATIONS value
     * @throws \InvalidArgumentException
     * @param \StructType\NOTIFICATIONS[] $nOTIFICATIONS
     * @return \StructType\S_NOTIFICATION_SEARCH_V001Response
     */
    public function setNOTIFICATIONS(array $nOTIFICATIONS = array())
    {
        // validation for constraint: array
        if ('' !== ($nOTIFICATIONSArrayErrorMessage = self::validateNOTIFICATIONSForArrayConstraintsFromSetNOTIFICATIONS($nOTIFICATIONS))) {
            throw new \InvalidArgumentException($nOTIFICATIONSArrayErrorMessage, __LINE__);
        }
        $this->NOTIFICATIONS = $nOTIFICATIONS;
        return $this;
    }
    /**
     * Add item to NOTIFICATIONS value
     * @throws \InvalidArgumentException
     * @param \StructType\NOTIFICATIONS $item
     * @return \StructType\S_NOTIFICATION_SEARCH_V001Response
     */
    public function addToNOTIFICATIONS(\StructType\NOTIFICATIONS $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NOTIFICATIONS) {
            throw new \InvalidArgumentException(sprintf('The NOTIFICATIONS property can only contain items of type \StructType\NOTIFICATIONS, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NOTIFICATIONS[] = $item;
        return $this;
    }
}
