<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_NOTIFICATION_REGISTER_V002Request StructType
 * @subpackage Structs
 */
class S_NOTIFICATION_REGISTER_V002Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The NOTIFICATION_REGISTER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NOTIFICATION_REGISTER
     */
    public $NOTIFICATION_REGISTER;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_NOTIFICATION_REGISTER_V002Request
     * @uses S_NOTIFICATION_REGISTER_V002Request::setAuthentication()
     * @uses S_NOTIFICATION_REGISTER_V002Request::setNOTIFICATION_REGISTER()
     * @uses S_NOTIFICATION_REGISTER_V002Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\NOTIFICATION_REGISTER $nOTIFICATION_REGISTER
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\NOTIFICATION_REGISTER $nOTIFICATION_REGISTER = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setNOTIFICATION_REGISTER($nOTIFICATION_REGISTER)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_NOTIFICATION_REGISTER_V002Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get NOTIFICATION_REGISTER value
     * @return \StructType\NOTIFICATION_REGISTER
     */
    public function getNOTIFICATION_REGISTER()
    {
        return $this->{'NOTIFICATION-REGISTER'};
    }
    /**
     * Set NOTIFICATION_REGISTER value
     * @param \StructType\NOTIFICATION_REGISTER $nOTIFICATION_REGISTER
     * @return \StructType\S_NOTIFICATION_REGISTER_V002Request
     */
    public function setNOTIFICATION_REGISTER(\StructType\NOTIFICATION_REGISTER $nOTIFICATION_REGISTER = null)
    {
        $this->NOTIFICATION_REGISTER = $this->{'NOTIFICATION-REGISTER'} = $nOTIFICATION_REGISTER;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_NOTIFICATION_REGISTER_V002Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
