<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_TRAIL_NODE_GET_V001Response StructType
 * @subpackage Structs
 */
class S_GUEST_TRAIL_NODE_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Trails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Trails[]
     */
    public $Trails;
    /**
     * Constructor method for S_GUEST_TRAIL_NODE_GET_V001Response
     * @uses S_GUEST_TRAIL_NODE_GET_V001Response::setResult()
     * @uses S_GUEST_TRAIL_NODE_GET_V001Response::setTransactionID()
     * @uses S_GUEST_TRAIL_NODE_GET_V001Response::setTrails()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Trails[] $trails
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $trails = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setTrails($trails);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GUEST_TRAIL_NODE_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_TRAIL_NODE_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Trails value
     * @return \StructType\Trails[]|null
     */
    public function getTrails()
    {
        return $this->Trails;
    }
    /**
     * This method is responsible for validating the values passed to the setTrails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrailsForArrayConstraintsFromSetTrails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GUEST_TRAIL_NODE_GET_V001ResponseTrailsItem) {
            // validation for constraint: itemType
            if (!$s_GUEST_TRAIL_NODE_GET_V001ResponseTrailsItem instanceof \StructType\Trails) {
                $invalidValues[] = is_object($s_GUEST_TRAIL_NODE_GET_V001ResponseTrailsItem) ? get_class($s_GUEST_TRAIL_NODE_GET_V001ResponseTrailsItem) : sprintf('%s(%s)', gettype($s_GUEST_TRAIL_NODE_GET_V001ResponseTrailsItem), var_export($s_GUEST_TRAIL_NODE_GET_V001ResponseTrailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Trails property can only contain items of type \StructType\Trails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Trails value
     * @throws \InvalidArgumentException
     * @param \StructType\Trails[] $trails
     * @return \StructType\S_GUEST_TRAIL_NODE_GET_V001Response
     */
    public function setTrails(array $trails = array())
    {
        // validation for constraint: array
        if ('' !== ($trailsArrayErrorMessage = self::validateTrailsForArrayConstraintsFromSetTrails($trails))) {
            throw new \InvalidArgumentException($trailsArrayErrorMessage, __LINE__);
        }
        $this->Trails = $trails;
        return $this;
    }
    /**
     * Add item to Trails value
     * @throws \InvalidArgumentException
     * @param \StructType\Trails $item
     * @return \StructType\S_GUEST_TRAIL_NODE_GET_V001Response
     */
    public function addToTrails(\StructType\Trails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Trails) {
            throw new \InvalidArgumentException(sprintf('The Trails property can only contain items of type \StructType\Trails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Trails[] = $item;
        return $this;
    }
}
