<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request StructType
 * @subpackage Structs
 */
class S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Guest_1
     */
    public $Guest;
    /**
     * The SettlementProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SettlementProfile
     */
    public $SettlementProfile;
    /**
     * The SettlementProfileData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SettlementProfileData
     */
    public $SettlementProfileData;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request
     * @uses S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request::setAuthentication()
     * @uses S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request::setGuest()
     * @uses S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request::setSettlementProfile()
     * @uses S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request::setSettlementProfileData()
     * @uses S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\Guest_1 $guest
     * @param \StructType\SettlementProfile $settlementProfile
     * @param \StructType\SettlementProfileData $settlementProfileData
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\Guest_1 $guest = null, \StructType\SettlementProfile $settlementProfile = null, \StructType\SettlementProfileData $settlementProfileData = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setGuest($guest)
            ->setSettlementProfile($settlementProfile)
            ->setSettlementProfileData($settlementProfileData)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get Guest value
     * @return \StructType\Guest_1
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * Set Guest value
     * @param \StructType\Guest_1 $guest
     * @return \StructType\S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request
     */
    public function setGuest(\StructType\Guest_1 $guest = null)
    {
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Get SettlementProfile value
     * @return \StructType\SettlementProfile
     */
    public function getSettlementProfile()
    {
        return $this->SettlementProfile;
    }
    /**
     * Set SettlementProfile value
     * @param \StructType\SettlementProfile $settlementProfile
     * @return \StructType\S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request
     */
    public function setSettlementProfile(\StructType\SettlementProfile $settlementProfile = null)
    {
        $this->SettlementProfile = $settlementProfile;
        return $this;
    }
    /**
     * Get SettlementProfileData value
     * @return \StructType\SettlementProfileData
     */
    public function getSettlementProfileData()
    {
        return $this->SettlementProfileData;
    }
    /**
     * Set SettlementProfileData value
     * @param \StructType\SettlementProfileData $settlementProfileData
     * @return \StructType\S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request
     */
    public function setSettlementProfileData(\StructType\SettlementProfileData $settlementProfileData = null)
    {
        $this->SettlementProfileData = $settlementProfileData;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_SETTLEMENT_PROFILE_ADD_V002Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
