<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_GET_V001Response StructType
 * @subpackage Structs
 */
class S_GUEST_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guest_1[]
     */
    public $Guest;
    /**
     * Constructor method for S_GUEST_GET_V001Response
     * @uses S_GUEST_GET_V001Response::setResult()
     * @uses S_GUEST_GET_V001Response::setTransactionID()
     * @uses S_GUEST_GET_V001Response::setGuest()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Guest_1[] $guest
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $guest = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setGuest($guest);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GUEST_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Guest value
     * @return \StructType\Guest_1[]|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestForArrayConstraintsFromSetGuest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GUEST_GET_V001ResponseGuestItem) {
            // validation for constraint: itemType
            if (!$s_GUEST_GET_V001ResponseGuestItem instanceof \StructType\Guest_1) {
                $invalidValues[] = is_object($s_GUEST_GET_V001ResponseGuestItem) ? get_class($s_GUEST_GET_V001ResponseGuestItem) : sprintf('%s(%s)', gettype($s_GUEST_GET_V001ResponseGuestItem), var_export($s_GUEST_GET_V001ResponseGuestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest property can only contain items of type \StructType\Guest_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_1[] $guest
     * @return \StructType\S_GUEST_GET_V001Response
     */
    public function setGuest(array $guest = array())
    {
        // validation for constraint: array
        if ('' !== ($guestArrayErrorMessage = self::validateGuestForArrayConstraintsFromSetGuest($guest))) {
            throw new \InvalidArgumentException($guestArrayErrorMessage, __LINE__);
        }
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Add item to Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_1 $item
     * @return \StructType\S_GUEST_GET_V001Response
     */
    public function addToGuest(\StructType\Guest_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guest_1) {
            throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of type \StructType\Guest_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest[] = $item;
        return $this;
    }
}
