<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_CRITERIA_MODIFY_V001Request StructType
 * @subpackage Structs
 */
class S_GUEST_CRITERIA_MODIFY_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The GUEST
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GUEST
     */
    public $GUEST;
    /**
     * The GUESTCRITERIA
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\GUESTCRITERIA[]
     */
    public $GUESTCRITERIA;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GUEST_CRITERIA_MODIFY_V001Request
     * @uses S_GUEST_CRITERIA_MODIFY_V001Request::setAuthentication()
     * @uses S_GUEST_CRITERIA_MODIFY_V001Request::setGUEST()
     * @uses S_GUEST_CRITERIA_MODIFY_V001Request::setGUESTCRITERIA()
     * @uses S_GUEST_CRITERIA_MODIFY_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\GUEST $gUEST
     * @param \StructType\GUESTCRITERIA[] $gUESTCRITERIA
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\GUEST $gUEST = null, array $gUESTCRITERIA = array(), $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setGUEST($gUEST)
            ->setGUESTCRITERIA($gUESTCRITERIA)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GUEST_CRITERIA_MODIFY_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get GUEST value
     * @return \StructType\GUEST
     */
    public function getGUEST()
    {
        return $this->GUEST;
    }
    /**
     * Set GUEST value
     * @param \StructType\GUEST $gUEST
     * @return \StructType\S_GUEST_CRITERIA_MODIFY_V001Request
     */
    public function setGUEST(\StructType\GUEST $gUEST = null)
    {
        $this->GUEST = $gUEST;
        return $this;
    }
    /**
     * Get GUESTCRITERIA value
     * @return \StructType\GUESTCRITERIA[]
     */
    public function getGUESTCRITERIA()
    {
        return $this->GUESTCRITERIA;
    }
    /**
     * This method is responsible for validating the values passed to the setGUESTCRITERIA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUESTCRITERIA method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTCRITERIAForArrayConstraintsFromSetGUESTCRITERIA(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GUEST_CRITERIA_MODIFY_V001RequestGUESTCRITERIAItem) {
            // validation for constraint: itemType
            if (!$s_GUEST_CRITERIA_MODIFY_V001RequestGUESTCRITERIAItem instanceof \StructType\GUESTCRITERIA) {
                $invalidValues[] = is_object($s_GUEST_CRITERIA_MODIFY_V001RequestGUESTCRITERIAItem) ? get_class($s_GUEST_CRITERIA_MODIFY_V001RequestGUESTCRITERIAItem) : sprintf('%s(%s)', gettype($s_GUEST_CRITERIA_MODIFY_V001RequestGUESTCRITERIAItem), var_export($s_GUEST_CRITERIA_MODIFY_V001RequestGUESTCRITERIAItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUESTCRITERIA property can only contain items of type \StructType\GUESTCRITERIA, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUESTCRITERIA value
     * @throws \InvalidArgumentException
     * @param \StructType\GUESTCRITERIA[] $gUESTCRITERIA
     * @return \StructType\S_GUEST_CRITERIA_MODIFY_V001Request
     */
    public function setGUESTCRITERIA(array $gUESTCRITERIA = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTCRITERIAArrayErrorMessage = self::validateGUESTCRITERIAForArrayConstraintsFromSetGUESTCRITERIA($gUESTCRITERIA))) {
            throw new \InvalidArgumentException($gUESTCRITERIAArrayErrorMessage, __LINE__);
        }
        $this->GUESTCRITERIA = $gUESTCRITERIA;
        return $this;
    }
    /**
     * Add item to GUESTCRITERIA value
     * @throws \InvalidArgumentException
     * @param \StructType\GUESTCRITERIA $item
     * @return \StructType\S_GUEST_CRITERIA_MODIFY_V001Request
     */
    public function addToGUESTCRITERIA(\StructType\GUESTCRITERIA $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUESTCRITERIA) {
            throw new \InvalidArgumentException(sprintf('The GUESTCRITERIA property can only contain items of type \StructType\GUESTCRITERIA, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUESTCRITERIA[] = $item;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_CRITERIA_MODIFY_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
