<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_CRITERIA_GET_V001Response StructType
 * @subpackage Structs
 */
class S_GUEST_CRITERIA_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The GUESTCRITERIA
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUESTCRITERIA[]
     */
    public $GUESTCRITERIA;
    /**
     * Constructor method for S_GUEST_CRITERIA_GET_V001Response
     * @uses S_GUEST_CRITERIA_GET_V001Response::setResult()
     * @uses S_GUEST_CRITERIA_GET_V001Response::setTransactionID()
     * @uses S_GUEST_CRITERIA_GET_V001Response::setGUESTCRITERIA()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\GUESTCRITERIA[] $gUESTCRITERIA
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $gUESTCRITERIA = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setGUESTCRITERIA($gUESTCRITERIA);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GUEST_CRITERIA_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_CRITERIA_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get GUESTCRITERIA value
     * @return \StructType\GUESTCRITERIA[]|null
     */
    public function getGUESTCRITERIA()
    {
        return $this->GUESTCRITERIA;
    }
    /**
     * This method is responsible for validating the values passed to the setGUESTCRITERIA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUESTCRITERIA method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTCRITERIAForArrayConstraintsFromSetGUESTCRITERIA(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GUEST_CRITERIA_GET_V001ResponseGUESTCRITERIAItem) {
            // validation for constraint: itemType
            if (!$s_GUEST_CRITERIA_GET_V001ResponseGUESTCRITERIAItem instanceof \StructType\GUESTCRITERIA) {
                $invalidValues[] = is_object($s_GUEST_CRITERIA_GET_V001ResponseGUESTCRITERIAItem) ? get_class($s_GUEST_CRITERIA_GET_V001ResponseGUESTCRITERIAItem) : sprintf('%s(%s)', gettype($s_GUEST_CRITERIA_GET_V001ResponseGUESTCRITERIAItem), var_export($s_GUEST_CRITERIA_GET_V001ResponseGUESTCRITERIAItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUESTCRITERIA property can only contain items of type \StructType\GUESTCRITERIA, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUESTCRITERIA value
     * @throws \InvalidArgumentException
     * @param \StructType\GUESTCRITERIA[] $gUESTCRITERIA
     * @return \StructType\S_GUEST_CRITERIA_GET_V001Response
     */
    public function setGUESTCRITERIA(array $gUESTCRITERIA = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTCRITERIAArrayErrorMessage = self::validateGUESTCRITERIAForArrayConstraintsFromSetGUESTCRITERIA($gUESTCRITERIA))) {
            throw new \InvalidArgumentException($gUESTCRITERIAArrayErrorMessage, __LINE__);
        }
        $this->GUESTCRITERIA = $gUESTCRITERIA;
        return $this;
    }
    /**
     * Add item to GUESTCRITERIA value
     * @throws \InvalidArgumentException
     * @param \StructType\GUESTCRITERIA $item
     * @return \StructType\S_GUEST_CRITERIA_GET_V001Response
     */
    public function addToGUESTCRITERIA(\StructType\GUESTCRITERIA $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUESTCRITERIA) {
            throw new \InvalidArgumentException(sprintf('The GUESTCRITERIA property can only contain items of type \StructType\GUESTCRITERIA, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUESTCRITERIA[] = $item;
        return $this;
    }
}
