<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_COMMENT_GET_V001Response StructType
 * @subpackage Structs
 */
class S_GUEST_COMMENT_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The COMMENTS
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\COMMENTS_1[]
     */
    public $COMMENTS;
    /**
     * Constructor method for S_GUEST_COMMENT_GET_V001Response
     * @uses S_GUEST_COMMENT_GET_V001Response::setResult()
     * @uses S_GUEST_COMMENT_GET_V001Response::setTransactionID()
     * @uses S_GUEST_COMMENT_GET_V001Response::setCOMMENTS()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\COMMENTS_1[] $cOMMENTS
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $cOMMENTS = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setCOMMENTS($cOMMENTS);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GUEST_COMMENT_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_COMMENT_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get COMMENTS value
     * @return \StructType\COMMENTS_1[]|null
     */
    public function getCOMMENTS()
    {
        return $this->COMMENTS;
    }
    /**
     * This method is responsible for validating the values passed to the setCOMMENTS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCOMMENTS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCOMMENTSForArrayConstraintsFromSetCOMMENTS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GUEST_COMMENT_GET_V001ResponseCOMMENTSItem) {
            // validation for constraint: itemType
            if (!$s_GUEST_COMMENT_GET_V001ResponseCOMMENTSItem instanceof \StructType\COMMENTS_1) {
                $invalidValues[] = is_object($s_GUEST_COMMENT_GET_V001ResponseCOMMENTSItem) ? get_class($s_GUEST_COMMENT_GET_V001ResponseCOMMENTSItem) : sprintf('%s(%s)', gettype($s_GUEST_COMMENT_GET_V001ResponseCOMMENTSItem), var_export($s_GUEST_COMMENT_GET_V001ResponseCOMMENTSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The COMMENTS property can only contain items of type \StructType\COMMENTS_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set COMMENTS value
     * @throws \InvalidArgumentException
     * @param \StructType\COMMENTS_1[] $cOMMENTS
     * @return \StructType\S_GUEST_COMMENT_GET_V001Response
     */
    public function setCOMMENTS(array $cOMMENTS = array())
    {
        // validation for constraint: array
        if ('' !== ($cOMMENTSArrayErrorMessage = self::validateCOMMENTSForArrayConstraintsFromSetCOMMENTS($cOMMENTS))) {
            throw new \InvalidArgumentException($cOMMENTSArrayErrorMessage, __LINE__);
        }
        $this->COMMENTS = $cOMMENTS;
        return $this;
    }
    /**
     * Add item to COMMENTS value
     * @throws \InvalidArgumentException
     * @param \StructType\COMMENTS_1 $item
     * @return \StructType\S_GUEST_COMMENT_GET_V001Response
     */
    public function addToCOMMENTS(\StructType\COMMENTS_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\COMMENTS_1) {
            throw new \InvalidArgumentException(sprintf('The COMMENTS property can only contain items of type \StructType\COMMENTS_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->COMMENTS[] = $item;
        return $this;
    }
}
