<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GO_RESERVATION_V002Response StructType
 * @subpackage Structs
 */
class S_GO_RESERVATION_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Reservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Reservation_1[]
     */
    public $Reservation;
    /**
     * Constructor method for S_GO_RESERVATION_V002Response
     * @uses S_GO_RESERVATION_V002Response::setResult()
     * @uses S_GO_RESERVATION_V002Response::setTransactionID()
     * @uses S_GO_RESERVATION_V002Response::setReservation()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Reservation_1[] $reservation
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $reservation = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setReservation($reservation);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GO_RESERVATION_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GO_RESERVATION_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Reservation value
     * @return \StructType\Reservation_1[]|null
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * This method is responsible for validating the values passed to the setReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationForArrayConstraintsFromSetReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GO_RESERVATION_V002ResponseReservationItem) {
            // validation for constraint: itemType
            if (!$s_GO_RESERVATION_V002ResponseReservationItem instanceof \StructType\Reservation_1) {
                $invalidValues[] = is_object($s_GO_RESERVATION_V002ResponseReservationItem) ? get_class($s_GO_RESERVATION_V002ResponseReservationItem) : sprintf('%s(%s)', gettype($s_GO_RESERVATION_V002ResponseReservationItem), var_export($s_GO_RESERVATION_V002ResponseReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reservation property can only contain items of type \StructType\Reservation_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reservation value
     * @throws \InvalidArgumentException
     * @param \StructType\Reservation_1[] $reservation
     * @return \StructType\S_GO_RESERVATION_V002Response
     */
    public function setReservation(array $reservation = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationArrayErrorMessage = self::validateReservationForArrayConstraintsFromSetReservation($reservation))) {
            throw new \InvalidArgumentException($reservationArrayErrorMessage, __LINE__);
        }
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Add item to Reservation value
     * @throws \InvalidArgumentException
     * @param \StructType\Reservation_1 $item
     * @return \StructType\S_GO_RESERVATION_V002Response
     */
    public function addToReservation(\StructType\Reservation_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Reservation_1) {
            throw new \InvalidArgumentException(sprintf('The Reservation property can only contain items of type \StructType\Reservation_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reservation[] = $item;
        return $this;
    }
}
