<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request
 * StructType
 * @subpackage Structs
 */
class S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The EventReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\EventReservation
     */
    public $EventReservation;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request
     * @uses S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request::setAuthentication()
     * @uses S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request::setEventReservation()
     * @uses S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\EventReservation $eventReservation
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\EventReservation $eventReservation = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setEventReservation($eventReservation)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get EventReservation value
     * @return \StructType\EventReservation
     */
    public function getEventReservation()
    {
        return $this->EventReservation;
    }
    /**
     * Set EventReservation value
     * @param \StructType\EventReservation $eventReservation
     * @return \StructType\S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request
     */
    public function setEventReservation(\StructType\EventReservation $eventReservation = null)
    {
        $this->EventReservation = $eventReservation;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
