<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_COMBOBOX_SEARCH_V01Response StructType
 * @subpackage Structs
 */
class S_COMBOBOX_SEARCH_V01Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ComboBox
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ComboBox[]
     */
    public $ComboBox;
    /**
     * Constructor method for S_COMBOBOX_SEARCH_V01Response
     * @uses S_COMBOBOX_SEARCH_V01Response::setResult()
     * @uses S_COMBOBOX_SEARCH_V01Response::setTransactionID()
     * @uses S_COMBOBOX_SEARCH_V01Response::setComboBox()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\ComboBox[] $comboBox
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $comboBox = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setComboBox($comboBox);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_COMBOBOX_SEARCH_V01Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_COMBOBOX_SEARCH_V01Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ComboBox value
     * @return \StructType\ComboBox[]|null
     */
    public function getComboBox()
    {
        return $this->ComboBox;
    }
    /**
     * This method is responsible for validating the values passed to the setComboBox method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComboBox method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComboBoxForArrayConstraintsFromSetComboBox(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_COMBOBOX_SEARCH_V01ResponseComboBoxItem) {
            // validation for constraint: itemType
            if (!$s_COMBOBOX_SEARCH_V01ResponseComboBoxItem instanceof \StructType\ComboBox) {
                $invalidValues[] = is_object($s_COMBOBOX_SEARCH_V01ResponseComboBoxItem) ? get_class($s_COMBOBOX_SEARCH_V01ResponseComboBoxItem) : sprintf('%s(%s)', gettype($s_COMBOBOX_SEARCH_V01ResponseComboBoxItem), var_export($s_COMBOBOX_SEARCH_V01ResponseComboBoxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ComboBox property can only contain items of type \StructType\ComboBox, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ComboBox value
     * @throws \InvalidArgumentException
     * @param \StructType\ComboBox[] $comboBox
     * @return \StructType\S_COMBOBOX_SEARCH_V01Response
     */
    public function setComboBox(array $comboBox = array())
    {
        // validation for constraint: array
        if ('' !== ($comboBoxArrayErrorMessage = self::validateComboBoxForArrayConstraintsFromSetComboBox($comboBox))) {
            throw new \InvalidArgumentException($comboBoxArrayErrorMessage, __LINE__);
        }
        $this->ComboBox = $comboBox;
        return $this;
    }
    /**
     * Add item to ComboBox value
     * @throws \InvalidArgumentException
     * @param \StructType\ComboBox $item
     * @return \StructType\S_COMBOBOX_SEARCH_V01Response
     */
    public function addToComboBox(\StructType\ComboBox $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ComboBox) {
            throw new \InvalidArgumentException(sprintf('The ComboBox property can only contain items of type \StructType\ComboBox, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ComboBox[] = $item;
        return $this;
    }
}
