<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_CITY_LEDGER_ACCOUNT_GET_V001Response StructType
 * @subpackage Structs
 */
class S_CITY_LEDGER_ACCOUNT_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The CITYLEDGER_ACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CITYLEDGER_ACCOUNT[]
     */
    public $CITYLEDGER_ACCOUNT;
    /**
     * Constructor method for S_CITY_LEDGER_ACCOUNT_GET_V001Response
     * @uses S_CITY_LEDGER_ACCOUNT_GET_V001Response::setResult()
     * @uses S_CITY_LEDGER_ACCOUNT_GET_V001Response::setTransactionID()
     * @uses S_CITY_LEDGER_ACCOUNT_GET_V001Response::setCITYLEDGER_ACCOUNT()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\CITYLEDGER_ACCOUNT[] $cITYLEDGER_ACCOUNT
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $cITYLEDGER_ACCOUNT = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setCITYLEDGER_ACCOUNT($cITYLEDGER_ACCOUNT);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_CITY_LEDGER_ACCOUNT_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_CITY_LEDGER_ACCOUNT_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get CITYLEDGER_ACCOUNT value
     * @return \StructType\CITYLEDGER_ACCOUNT[]|null
     */
    public function getCITYLEDGER_ACCOUNT()
    {
        return $this->{'CITYLEDGER-ACCOUNT'};
    }
    /**
     * This method is responsible for validating the values passed to the setCITYLEDGER_ACCOUNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCITYLEDGER_ACCOUNT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCITYLEDGER_ACCOUNTForArrayConstraintsFromSetCITYLEDGER_ACCOUNT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_CITY_LEDGER_ACCOUNT_GET_V001ResponseCITYLEDGER_ACCOUNTItem) {
            // validation for constraint: itemType
            if (!$s_CITY_LEDGER_ACCOUNT_GET_V001ResponseCITYLEDGER_ACCOUNTItem instanceof \StructType\CITYLEDGER_ACCOUNT) {
                $invalidValues[] = is_object($s_CITY_LEDGER_ACCOUNT_GET_V001ResponseCITYLEDGER_ACCOUNTItem) ? get_class($s_CITY_LEDGER_ACCOUNT_GET_V001ResponseCITYLEDGER_ACCOUNTItem) : sprintf('%s(%s)', gettype($s_CITY_LEDGER_ACCOUNT_GET_V001ResponseCITYLEDGER_ACCOUNTItem), var_export($s_CITY_LEDGER_ACCOUNT_GET_V001ResponseCITYLEDGER_ACCOUNTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CITYLEDGER_ACCOUNT property can only contain items of type \StructType\CITYLEDGER_ACCOUNT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CITYLEDGER_ACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\CITYLEDGER_ACCOUNT[] $cITYLEDGER_ACCOUNT
     * @return \StructType\S_CITY_LEDGER_ACCOUNT_GET_V001Response
     */
    public function setCITYLEDGER_ACCOUNT(array $cITYLEDGER_ACCOUNT = array())
    {
        // validation for constraint: array
        if ('' !== ($cITYLEDGER_ACCOUNTArrayErrorMessage = self::validateCITYLEDGER_ACCOUNTForArrayConstraintsFromSetCITYLEDGER_ACCOUNT($cITYLEDGER_ACCOUNT))) {
            throw new \InvalidArgumentException($cITYLEDGER_ACCOUNTArrayErrorMessage, __LINE__);
        }
        $this->CITYLEDGER_ACCOUNT = $this->{'CITYLEDGER-ACCOUNT'} = $cITYLEDGER_ACCOUNT;
        return $this;
    }
    /**
     * Add item to CITYLEDGER_ACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\CITYLEDGER_ACCOUNT $item
     * @return \StructType\S_CITY_LEDGER_ACCOUNT_GET_V001Response
     */
    public function addToCITYLEDGER_ACCOUNT(\StructType\CITYLEDGER_ACCOUNT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CITYLEDGER_ACCOUNT) {
            throw new \InvalidArgumentException(sprintf('The CITYLEDGER_ACCOUNT property can only contain items of type \StructType\CITYLEDGER_ACCOUNT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CITYLEDGER_ACCOUNT[] = $this->{'CITYLEDGER-ACCOUNT'}[] = $item;
        return $this;
    }
}
