<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_CITY_LEDGER_ACCOUNT_GET_V001Request StructType
 * @subpackage Structs
 */
class S_CITY_LEDGER_ACCOUNT_GET_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The CITYLEDGER_ACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CITYLEDGER_ACCOUNT
     */
    public $CITYLEDGER_ACCOUNT;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_CITY_LEDGER_ACCOUNT_GET_V001Request
     * @uses S_CITY_LEDGER_ACCOUNT_GET_V001Request::setAuthentication()
     * @uses S_CITY_LEDGER_ACCOUNT_GET_V001Request::setCITYLEDGER_ACCOUNT()
     * @uses S_CITY_LEDGER_ACCOUNT_GET_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\CITYLEDGER_ACCOUNT $cITYLEDGER_ACCOUNT
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\CITYLEDGER_ACCOUNT $cITYLEDGER_ACCOUNT = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setCITYLEDGER_ACCOUNT($cITYLEDGER_ACCOUNT)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_CITY_LEDGER_ACCOUNT_GET_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get CITYLEDGER_ACCOUNT value
     * @return \StructType\CITYLEDGER_ACCOUNT
     */
    public function getCITYLEDGER_ACCOUNT()
    {
        return $this->{'CITYLEDGER-ACCOUNT'};
    }
    /**
     * Set CITYLEDGER_ACCOUNT value
     * @param \StructType\CITYLEDGER_ACCOUNT $cITYLEDGER_ACCOUNT
     * @return \StructType\S_CITY_LEDGER_ACCOUNT_GET_V001Request
     */
    public function setCITYLEDGER_ACCOUNT(\StructType\CITYLEDGER_ACCOUNT $cITYLEDGER_ACCOUNT = null)
    {
        $this->CITYLEDGER_ACCOUNT = $this->{'CITYLEDGER-ACCOUNT'} = $cITYLEDGER_ACCOUNT;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_CITY_LEDGER_ACCOUNT_GET_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
