<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_AUTOTASK_CONFIRMATION_V001Request StructType
 * @subpackage Structs
 */
class S_AUTOTASK_CONFIRMATION_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The AutoTaskConfirm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AutoTaskConfirm
     */
    public $AutoTaskConfirm;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_AUTOTASK_CONFIRMATION_V001Request
     * @uses S_AUTOTASK_CONFIRMATION_V001Request::setAuthentication()
     * @uses S_AUTOTASK_CONFIRMATION_V001Request::setAutoTaskConfirm()
     * @uses S_AUTOTASK_CONFIRMATION_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\AutoTaskConfirm $autoTaskConfirm
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\AutoTaskConfirm $autoTaskConfirm = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setAutoTaskConfirm($autoTaskConfirm)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_AUTOTASK_CONFIRMATION_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get AutoTaskConfirm value
     * @return \StructType\AutoTaskConfirm
     */
    public function getAutoTaskConfirm()
    {
        return $this->AutoTaskConfirm;
    }
    /**
     * Set AutoTaskConfirm value
     * @param \StructType\AutoTaskConfirm $autoTaskConfirm
     * @return \StructType\S_AUTOTASK_CONFIRMATION_V001Request
     */
    public function setAutoTaskConfirm(\StructType\AutoTaskConfirm $autoTaskConfirm = null)
    {
        $this->AutoTaskConfirm = $autoTaskConfirm;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_AUTOTASK_CONFIRMATION_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
