<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_AUTHENTICATE_HOTEL_V001Response StructType
 * @subpackage Structs
 */
class S_AUTHENTICATE_HOTEL_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The AUTHENTICATION
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AUTHENTICATION_1[]
     */
    public $AUTHENTICATION;
    /**
     * Constructor method for S_AUTHENTICATE_HOTEL_V001Response
     * @uses S_AUTHENTICATE_HOTEL_V001Response::setResult()
     * @uses S_AUTHENTICATE_HOTEL_V001Response::setTransactionID()
     * @uses S_AUTHENTICATE_HOTEL_V001Response::setAUTHENTICATION()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\AUTHENTICATION_1[] $aUTHENTICATION
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $aUTHENTICATION = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setAUTHENTICATION($aUTHENTICATION);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_AUTHENTICATE_HOTEL_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_AUTHENTICATE_HOTEL_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get AUTHENTICATION value
     * @return \StructType\AUTHENTICATION_1[]|null
     */
    public function getAUTHENTICATION()
    {
        return $this->AUTHENTICATION;
    }
    /**
     * This method is responsible for validating the values passed to the setAUTHENTICATION method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAUTHENTICATION method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAUTHENTICATIONForArrayConstraintsFromSetAUTHENTICATION(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_AUTHENTICATE_HOTEL_V001ResponseAUTHENTICATIONItem) {
            // validation for constraint: itemType
            if (!$s_AUTHENTICATE_HOTEL_V001ResponseAUTHENTICATIONItem instanceof \StructType\AUTHENTICATION_1) {
                $invalidValues[] = is_object($s_AUTHENTICATE_HOTEL_V001ResponseAUTHENTICATIONItem) ? get_class($s_AUTHENTICATE_HOTEL_V001ResponseAUTHENTICATIONItem) : sprintf('%s(%s)', gettype($s_AUTHENTICATE_HOTEL_V001ResponseAUTHENTICATIONItem), var_export($s_AUTHENTICATE_HOTEL_V001ResponseAUTHENTICATIONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AUTHENTICATION property can only contain items of type \StructType\AUTHENTICATION_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AUTHENTICATION value
     * @throws \InvalidArgumentException
     * @param \StructType\AUTHENTICATION_1[] $aUTHENTICATION
     * @return \StructType\S_AUTHENTICATE_HOTEL_V001Response
     */
    public function setAUTHENTICATION(array $aUTHENTICATION = array())
    {
        // validation for constraint: array
        if ('' !== ($aUTHENTICATIONArrayErrorMessage = self::validateAUTHENTICATIONForArrayConstraintsFromSetAUTHENTICATION($aUTHENTICATION))) {
            throw new \InvalidArgumentException($aUTHENTICATIONArrayErrorMessage, __LINE__);
        }
        $this->AUTHENTICATION = $aUTHENTICATION;
        return $this;
    }
    /**
     * Add item to AUTHENTICATION value
     * @throws \InvalidArgumentException
     * @param \StructType\AUTHENTICATION_1 $item
     * @return \StructType\S_AUTHENTICATE_HOTEL_V001Response
     */
    public function addToAUTHENTICATION(\StructType\AUTHENTICATION_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AUTHENTICATION_1) {
            throw new \InvalidArgumentException(sprintf('The AUTHENTICATION property can only contain items of type \StructType\AUTHENTICATION_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AUTHENTICATION[] = $item;
        return $this;
    }
}
