<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ARRIVAL_SEARCH_V002Response StructType
 * @subpackage Structs
 */
class S_ARRIVAL_SEARCH_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Room_1[]
     */
    public $room;
    /**
     * Constructor method for S_ARRIVAL_SEARCH_V002Response
     * @uses S_ARRIVAL_SEARCH_V002Response::setResult()
     * @uses S_ARRIVAL_SEARCH_V002Response::setTransactionID()
     * @uses S_ARRIVAL_SEARCH_V002Response::setRoom()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Room_1[] $room
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $room = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setRoom($room);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ARRIVAL_SEARCH_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ARRIVAL_SEARCH_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get room value
     * @return \StructType\Room_1[]|null
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ARRIVAL_SEARCH_V002ResponseRoomItem) {
            // validation for constraint: itemType
            if (!$s_ARRIVAL_SEARCH_V002ResponseRoomItem instanceof \StructType\Room_1) {
                $invalidValues[] = is_object($s_ARRIVAL_SEARCH_V002ResponseRoomItem) ? get_class($s_ARRIVAL_SEARCH_V002ResponseRoomItem) : sprintf('%s(%s)', gettype($s_ARRIVAL_SEARCH_V002ResponseRoomItem), var_export($s_ARRIVAL_SEARCH_V002ResponseRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The room property can only contain items of type \StructType\Room_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room_1[] $room
     * @return \StructType\S_ARRIVAL_SEARCH_V002Response
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Add item to room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room_1 $item
     * @return \StructType\S_ARRIVAL_SEARCH_V002Response
     */
    public function addToRoom(\StructType\Room_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Room_1) {
            throw new \InvalidArgumentException(sprintf('The room property can only contain items of type \StructType\Room_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->room[] = $item;
        return $this;
    }
}
