<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ARRIVAL_SEARCH_V002Request StructType
 * @subpackage Structs
 */
class S_ARRIVAL_SEARCH_V002Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The ArrivalSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ArrivalSearch
     */
    public $ArrivalSearch;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_ARRIVAL_SEARCH_V002Request
     * @uses S_ARRIVAL_SEARCH_V002Request::setAuthentication()
     * @uses S_ARRIVAL_SEARCH_V002Request::setArrivalSearch()
     * @uses S_ARRIVAL_SEARCH_V002Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\ArrivalSearch $arrivalSearch
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\ArrivalSearch $arrivalSearch = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setArrivalSearch($arrivalSearch)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ARRIVAL_SEARCH_V002Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get ArrivalSearch value
     * @return \StructType\ArrivalSearch
     */
    public function getArrivalSearch()
    {
        return $this->ArrivalSearch;
    }
    /**
     * Set ArrivalSearch value
     * @param \StructType\ArrivalSearch $arrivalSearch
     * @return \StructType\S_ARRIVAL_SEARCH_V002Request
     */
    public function setArrivalSearch(\StructType\ArrivalSearch $arrivalSearch = null)
    {
        $this->ArrivalSearch = $arrivalSearch;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ARRIVAL_SEARCH_V002Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
