<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ALLOTMENT_RESTRICTIONS_GET_V001Request StructType
 * @subpackage Structs
 */
class S_ALLOTMENT_RESTRICTIONS_GET_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The ALLOTMENT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ALLOTMENT
     */
    public $ALLOTMENT;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_ALLOTMENT_RESTRICTIONS_GET_V001Request
     * @uses S_ALLOTMENT_RESTRICTIONS_GET_V001Request::setAuthentication()
     * @uses S_ALLOTMENT_RESTRICTIONS_GET_V001Request::setALLOTMENT()
     * @uses S_ALLOTMENT_RESTRICTIONS_GET_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\ALLOTMENT $aLLOTMENT
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\ALLOTMENT $aLLOTMENT = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setALLOTMENT($aLLOTMENT)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ALLOTMENT_RESTRICTIONS_GET_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get ALLOTMENT value
     * @return \StructType\ALLOTMENT
     */
    public function getALLOTMENT()
    {
        return $this->ALLOTMENT;
    }
    /**
     * Set ALLOTMENT value
     * @param \StructType\ALLOTMENT $aLLOTMENT
     * @return \StructType\S_ALLOTMENT_RESTRICTIONS_GET_V001Request
     */
    public function setALLOTMENT(\StructType\ALLOTMENT $aLLOTMENT = null)
    {
        $this->ALLOTMENT = $aLLOTMENT;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ALLOTMENT_RESTRICTIONS_GET_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
