<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ALLOTMENT_GET_V001Response StructType
 * @subpackage Structs
 */
class S_ALLOTMENT_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ALLOTMENT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ALLOTMENT[]
     */
    public $ALLOTMENT;
    /**
     * Constructor method for S_ALLOTMENT_GET_V001Response
     * @uses S_ALLOTMENT_GET_V001Response::setResult()
     * @uses S_ALLOTMENT_GET_V001Response::setTransactionID()
     * @uses S_ALLOTMENT_GET_V001Response::setALLOTMENT()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\ALLOTMENT[] $aLLOTMENT
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $aLLOTMENT = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setALLOTMENT($aLLOTMENT);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ALLOTMENT_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ALLOTMENT_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ALLOTMENT value
     * @return \StructType\ALLOTMENT[]|null
     */
    public function getALLOTMENT()
    {
        return $this->ALLOTMENT;
    }
    /**
     * This method is responsible for validating the values passed to the setALLOTMENT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setALLOTMENT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateALLOTMENTForArrayConstraintsFromSetALLOTMENT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ALLOTMENT_GET_V001ResponseALLOTMENTItem) {
            // validation for constraint: itemType
            if (!$s_ALLOTMENT_GET_V001ResponseALLOTMENTItem instanceof \StructType\ALLOTMENT) {
                $invalidValues[] = is_object($s_ALLOTMENT_GET_V001ResponseALLOTMENTItem) ? get_class($s_ALLOTMENT_GET_V001ResponseALLOTMENTItem) : sprintf('%s(%s)', gettype($s_ALLOTMENT_GET_V001ResponseALLOTMENTItem), var_export($s_ALLOTMENT_GET_V001ResponseALLOTMENTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ALLOTMENT property can only contain items of type \StructType\ALLOTMENT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ALLOTMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\ALLOTMENT[] $aLLOTMENT
     * @return \StructType\S_ALLOTMENT_GET_V001Response
     */
    public function setALLOTMENT(array $aLLOTMENT = array())
    {
        // validation for constraint: array
        if ('' !== ($aLLOTMENTArrayErrorMessage = self::validateALLOTMENTForArrayConstraintsFromSetALLOTMENT($aLLOTMENT))) {
            throw new \InvalidArgumentException($aLLOTMENTArrayErrorMessage, __LINE__);
        }
        $this->ALLOTMENT = $aLLOTMENT;
        return $this;
    }
    /**
     * Add item to ALLOTMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\ALLOTMENT $item
     * @return \StructType\S_ALLOTMENT_GET_V001Response
     */
    public function addToALLOTMENT(\StructType\ALLOTMENT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ALLOTMENT) {
            throw new \InvalidArgumentException(sprintf('The ALLOTMENT property can only contain items of type \StructType\ALLOTMENT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ALLOTMENT[] = $item;
        return $this;
    }
}
