<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACL_INFO_GET_V001Response StructType
 * @subpackage Structs
 */
class S_ACL_INFO_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ACLInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ACLInfo[]
     */
    public $ACLInfo;
    /**
     * Constructor method for S_ACL_INFO_GET_V001Response
     * @uses S_ACL_INFO_GET_V001Response::setResult()
     * @uses S_ACL_INFO_GET_V001Response::setTransactionID()
     * @uses S_ACL_INFO_GET_V001Response::setACLInfo()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\ACLInfo[] $aCLInfo
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $aCLInfo = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setACLInfo($aCLInfo);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ACL_INFO_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACL_INFO_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ACLInfo value
     * @return \StructType\ACLInfo[]|null
     */
    public function getACLInfo()
    {
        return $this->ACLInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setACLInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setACLInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateACLInfoForArrayConstraintsFromSetACLInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ACL_INFO_GET_V001ResponseACLInfoItem) {
            // validation for constraint: itemType
            if (!$s_ACL_INFO_GET_V001ResponseACLInfoItem instanceof \StructType\ACLInfo) {
                $invalidValues[] = is_object($s_ACL_INFO_GET_V001ResponseACLInfoItem) ? get_class($s_ACL_INFO_GET_V001ResponseACLInfoItem) : sprintf('%s(%s)', gettype($s_ACL_INFO_GET_V001ResponseACLInfoItem), var_export($s_ACL_INFO_GET_V001ResponseACLInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ACLInfo property can only contain items of type \StructType\ACLInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ACLInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ACLInfo[] $aCLInfo
     * @return \StructType\S_ACL_INFO_GET_V001Response
     */
    public function setACLInfo(array $aCLInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($aCLInfoArrayErrorMessage = self::validateACLInfoForArrayConstraintsFromSetACLInfo($aCLInfo))) {
            throw new \InvalidArgumentException($aCLInfoArrayErrorMessage, __LINE__);
        }
        $this->ACLInfo = $aCLInfo;
        return $this;
    }
    /**
     * Add item to ACLInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ACLInfo $item
     * @return \StructType\S_ACL_INFO_GET_V001Response
     */
    public function addToACLInfo(\StructType\ACLInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ACLInfo) {
            throw new \InvalidArgumentException(sprintf('The ACLInfo property can only contain items of type \StructType\ACLInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ACLInfo[] = $item;
        return $this;
    }
}
