<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_SERVICE_ADD_V002Response StructType
 * @subpackage Structs
 */
class S_ACCOUNT_SERVICE_ADD_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The PostFOServiceForOutput
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PostFOServiceForOutput[]
     */
    public $PostFOServiceForOutput;
    /**
     * Constructor method for S_ACCOUNT_SERVICE_ADD_V002Response
     * @uses S_ACCOUNT_SERVICE_ADD_V002Response::setResult()
     * @uses S_ACCOUNT_SERVICE_ADD_V002Response::setTransactionID()
     * @uses S_ACCOUNT_SERVICE_ADD_V002Response::setPostFOServiceForOutput()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\PostFOServiceForOutput[] $postFOServiceForOutput
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $postFOServiceForOutput = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setPostFOServiceForOutput($postFOServiceForOutput);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ACCOUNT_SERVICE_ADD_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_SERVICE_ADD_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get PostFOServiceForOutput value
     * @return \StructType\PostFOServiceForOutput[]|null
     */
    public function getPostFOServiceForOutput()
    {
        return $this->PostFOServiceForOutput;
    }
    /**
     * This method is responsible for validating the values passed to the setPostFOServiceForOutput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostFOServiceForOutput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostFOServiceForOutputForArrayConstraintsFromSetPostFOServiceForOutput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ACCOUNT_SERVICE_ADD_V002ResponsePostFOServiceForOutputItem) {
            // validation for constraint: itemType
            if (!$s_ACCOUNT_SERVICE_ADD_V002ResponsePostFOServiceForOutputItem instanceof \StructType\PostFOServiceForOutput) {
                $invalidValues[] = is_object($s_ACCOUNT_SERVICE_ADD_V002ResponsePostFOServiceForOutputItem) ? get_class($s_ACCOUNT_SERVICE_ADD_V002ResponsePostFOServiceForOutputItem) : sprintf('%s(%s)', gettype($s_ACCOUNT_SERVICE_ADD_V002ResponsePostFOServiceForOutputItem), var_export($s_ACCOUNT_SERVICE_ADD_V002ResponsePostFOServiceForOutputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PostFOServiceForOutput property can only contain items of type \StructType\PostFOServiceForOutput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PostFOServiceForOutput value
     * @throws \InvalidArgumentException
     * @param \StructType\PostFOServiceForOutput[] $postFOServiceForOutput
     * @return \StructType\S_ACCOUNT_SERVICE_ADD_V002Response
     */
    public function setPostFOServiceForOutput(array $postFOServiceForOutput = array())
    {
        // validation for constraint: array
        if ('' !== ($postFOServiceForOutputArrayErrorMessage = self::validatePostFOServiceForOutputForArrayConstraintsFromSetPostFOServiceForOutput($postFOServiceForOutput))) {
            throw new \InvalidArgumentException($postFOServiceForOutputArrayErrorMessage, __LINE__);
        }
        $this->PostFOServiceForOutput = $postFOServiceForOutput;
        return $this;
    }
    /**
     * Add item to PostFOServiceForOutput value
     * @throws \InvalidArgumentException
     * @param \StructType\PostFOServiceForOutput $item
     * @return \StructType\S_ACCOUNT_SERVICE_ADD_V002Response
     */
    public function addToPostFOServiceForOutput(\StructType\PostFOServiceForOutput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PostFOServiceForOutput) {
            throw new \InvalidArgumentException(sprintf('The PostFOServiceForOutput property can only contain items of type \StructType\PostFOServiceForOutput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PostFOServiceForOutput[] = $item;
        return $this;
    }
}
