<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_SEARCH_V003Response StructType
 * @subpackage Structs
 */
class S_ACCOUNT_SEARCH_V003Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Account_1[]
     */
    public $Account;
    /**
     * Constructor method for S_ACCOUNT_SEARCH_V003Response
     * @uses S_ACCOUNT_SEARCH_V003Response::setResult()
     * @uses S_ACCOUNT_SEARCH_V003Response::setTransactionID()
     * @uses S_ACCOUNT_SEARCH_V003Response::setAccount()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Account_1[] $account
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $account = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setAccount($account);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ACCOUNT_SEARCH_V003Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_SEARCH_V003Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\Account_1[]|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ACCOUNT_SEARCH_V003ResponseAccountItem) {
            // validation for constraint: itemType
            if (!$s_ACCOUNT_SEARCH_V003ResponseAccountItem instanceof \StructType\Account_1) {
                $invalidValues[] = is_object($s_ACCOUNT_SEARCH_V003ResponseAccountItem) ? get_class($s_ACCOUNT_SEARCH_V003ResponseAccountItem) : sprintf('%s(%s)', gettype($s_ACCOUNT_SEARCH_V003ResponseAccountItem), var_export($s_ACCOUNT_SEARCH_V003ResponseAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Account property can only contain items of type \StructType\Account_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Account_1[] $account
     * @return \StructType\S_ACCOUNT_SEARCH_V003Response
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Add item to Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Account_1 $item
     * @return \StructType\S_ACCOUNT_SEARCH_V003Response
     */
    public function addToAccount(\StructType\Account_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Account_1) {
            throw new \InvalidArgumentException(sprintf('The Account property can only contain items of type \StructType\Account_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Account[] = $item;
        return $this;
    }
}
