<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_SEARCH_V003Request StructType
 * @subpackage Structs
 */
class S_ACCOUNT_SEARCH_V003Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The AccountSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AccountSearch
     */
    public $AccountSearch;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_ACCOUNT_SEARCH_V003Request
     * @uses S_ACCOUNT_SEARCH_V003Request::setAuthentication()
     * @uses S_ACCOUNT_SEARCH_V003Request::setAccountSearch()
     * @uses S_ACCOUNT_SEARCH_V003Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\AccountSearch $accountSearch
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\AccountSearch $accountSearch = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setAccountSearch($accountSearch)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ACCOUNT_SEARCH_V003Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get AccountSearch value
     * @return \StructType\AccountSearch
     */
    public function getAccountSearch()
    {
        return $this->AccountSearch;
    }
    /**
     * Set AccountSearch value
     * @param \StructType\AccountSearch $accountSearch
     * @return \StructType\S_ACCOUNT_SEARCH_V003Request
     */
    public function setAccountSearch(\StructType\AccountSearch $accountSearch = null)
    {
        $this->AccountSearch = $accountSearch;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_SEARCH_V003Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
