<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_GET_V002Response StructType
 * @subpackage Structs
 */
class S_ACCOUNT_GET_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The MainAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MainAccount[]
     */
    public $MainAccount;
    /**
     * Constructor method for S_ACCOUNT_GET_V002Response
     * @uses S_ACCOUNT_GET_V002Response::setResult()
     * @uses S_ACCOUNT_GET_V002Response::setTransactionID()
     * @uses S_ACCOUNT_GET_V002Response::setMainAccount()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\MainAccount[] $mainAccount
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $mainAccount = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setMainAccount($mainAccount);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ACCOUNT_GET_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_GET_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get MainAccount value
     * @return \StructType\MainAccount[]|null
     */
    public function getMainAccount()
    {
        return $this->MainAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setMainAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMainAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMainAccountForArrayConstraintsFromSetMainAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ACCOUNT_GET_V002ResponseMainAccountItem) {
            // validation for constraint: itemType
            if (!$s_ACCOUNT_GET_V002ResponseMainAccountItem instanceof \StructType\MainAccount) {
                $invalidValues[] = is_object($s_ACCOUNT_GET_V002ResponseMainAccountItem) ? get_class($s_ACCOUNT_GET_V002ResponseMainAccountItem) : sprintf('%s(%s)', gettype($s_ACCOUNT_GET_V002ResponseMainAccountItem), var_export($s_ACCOUNT_GET_V002ResponseMainAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MainAccount property can only contain items of type \StructType\MainAccount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MainAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\MainAccount[] $mainAccount
     * @return \StructType\S_ACCOUNT_GET_V002Response
     */
    public function setMainAccount(array $mainAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($mainAccountArrayErrorMessage = self::validateMainAccountForArrayConstraintsFromSetMainAccount($mainAccount))) {
            throw new \InvalidArgumentException($mainAccountArrayErrorMessage, __LINE__);
        }
        $this->MainAccount = $mainAccount;
        return $this;
    }
    /**
     * Add item to MainAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\MainAccount $item
     * @return \StructType\S_ACCOUNT_GET_V002Response
     */
    public function addToMainAccount(\StructType\MainAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MainAccount) {
            throw new \InvalidArgumentException(sprintf('The MainAccount property can only contain items of type \StructType\MainAccount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MainAccount[] = $item;
        return $this;
    }
}
