<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request
 * StructType
 * @subpackage Structs
 */
class S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The PMSAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PMSAccount
     */
    public $PMSAccount;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request
     * @uses S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request::setAuthentication()
     * @uses S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request::setPMSAccount()
     * @uses S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\PMSAccount $pMSAccount
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\PMSAccount $pMSAccount = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setPMSAccount($pMSAccount)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get PMSAccount value
     * @return \StructType\PMSAccount
     */
    public function getPMSAccount()
    {
        return $this->PMSAccount;
    }
    /**
     * Set PMSAccount value
     * @param \StructType\PMSAccount $pMSAccount
     * @return \StructType\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request
     */
    public function setPMSAccount(\StructType\PMSAccount $pMSAccount = null)
    {
        $this->PMSAccount = $pMSAccount;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
