<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for STAY StructType
 * @subpackage Structs
 */
class STAY extends AbstractStructBase
{
    /**
     * The staying
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $staying;
    /**
     * The tooltip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tooltip;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The vipstayover
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vipstayover;
    /**
     * The amenities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $amenities;
    /**
     * Constructor method for STAY
     * @uses STAY::setStaying()
     * @uses STAY::setTooltip()
     * @uses STAY::setComment()
     * @uses STAY::setVipstayover()
     * @uses STAY::setAmenities()
     * @param string $staying
     * @param string $tooltip
     * @param string $comment
     * @param string $vipstayover
     * @param string $amenities
     */
    public function __construct($staying = null, $tooltip = null, $comment = null, $vipstayover = null, $amenities = null)
    {
        $this
            ->setStaying($staying)
            ->setTooltip($tooltip)
            ->setComment($comment)
            ->setVipstayover($vipstayover)
            ->setAmenities($amenities);
    }
    /**
     * Get staying value
     * @return string
     */
    public function getStaying()
    {
        return $this->staying;
    }
    /**
     * Set staying value
     * @param string $staying
     * @return \StructType\STAY
     */
    public function setStaying($staying = null)
    {
        // validation for constraint: string
        if (!is_null($staying) && !is_string($staying)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($staying, true), gettype($staying)), __LINE__);
        }
        $this->staying = $staying;
        return $this;
    }
    /**
     * Get tooltip value
     * @return string
     */
    public function getTooltip()
    {
        return $this->tooltip;
    }
    /**
     * Set tooltip value
     * @param string $tooltip
     * @return \StructType\STAY
     */
    public function setTooltip($tooltip = null)
    {
        // validation for constraint: string
        if (!is_null($tooltip) && !is_string($tooltip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tooltip, true), gettype($tooltip)), __LINE__);
        }
        $this->tooltip = $tooltip;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\STAY
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get vipstayover value
     * @return string
     */
    public function getVipstayover()
    {
        return $this->vipstayover;
    }
    /**
     * Set vipstayover value
     * @param string $vipstayover
     * @return \StructType\STAY
     */
    public function setVipstayover($vipstayover = null)
    {
        // validation for constraint: string
        if (!is_null($vipstayover) && !is_string($vipstayover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vipstayover, true), gettype($vipstayover)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vipstayover) && mb_strlen($vipstayover) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vipstayover)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vipstayover) && mb_strlen($vipstayover) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vipstayover)), __LINE__);
        }
        $this->vipstayover = $vipstayover;
        return $this;
    }
    /**
     * Get amenities value
     * @return string
     */
    public function getAmenities()
    {
        return $this->amenities;
    }
    /**
     * Set amenities value
     * @param string $amenities
     * @return \StructType\STAY
     */
    public function setAmenities($amenities = null)
    {
        // validation for constraint: string
        if (!is_null($amenities) && !is_string($amenities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amenities, true), gettype($amenities)), __LINE__);
        }
        $this->amenities = $amenities;
        return $this;
    }
}
