<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SERVICE-POSTING StructType
 * @subpackage Structs
 */
class SERVICE_POSTING extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The priceperunit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $priceperunit;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The persongroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $persongroup;
    /**
     * The paymentInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentInstructions;
    /**
     * Constructor method for SERVICE-POSTING
     * @uses SERVICE_POSTING::setDate()
     * @uses SERVICE_POSTING::setService()
     * @uses SERVICE_POSTING::setPriceperunit()
     * @uses SERVICE_POSTING::setAmount()
     * @uses SERVICE_POSTING::setCurrency()
     * @uses SERVICE_POSTING::setRatecategory()
     * @uses SERVICE_POSTING::setPersongroup()
     * @uses SERVICE_POSTING::setPaymentInstructions()
     * @param string $date
     * @param string $service
     * @param string $priceperunit
     * @param string $amount
     * @param string $currency
     * @param string $ratecategory
     * @param string $persongroup
     * @param string $paymentInstructions
     */
    public function __construct($date = null, $service = null, $priceperunit = null, $amount = null, $currency = null, $ratecategory = null, $persongroup = null, $paymentInstructions = null)
    {
        $this
            ->setDate($date)
            ->setService($service)
            ->setPriceperunit($priceperunit)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setRatecategory($ratecategory)
            ->setPersongroup($persongroup)
            ->setPaymentInstructions($paymentInstructions);
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\SERVICE_POSTING
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\SERVICE_POSTING
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get priceperunit value
     * @return string
     */
    public function getPriceperunit()
    {
        return $this->priceperunit;
    }
    /**
     * Set priceperunit value
     * @param string $priceperunit
     * @return \StructType\SERVICE_POSTING
     */
    public function setPriceperunit($priceperunit = null)
    {
        // validation for constraint: string
        if (!is_null($priceperunit) && !is_string($priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceperunit, true), gettype($priceperunit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($priceperunit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($priceperunit, true)), __LINE__);
        }
        $this->priceperunit = $priceperunit;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\SERVICE_POSTING
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\SERVICE_POSTING
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\SERVICE_POSTING
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get persongroup value
     * @return string
     */
    public function getPersongroup()
    {
        return $this->persongroup;
    }
    /**
     * Set persongroup value
     * @param string $persongroup
     * @return \StructType\SERVICE_POSTING
     */
    public function setPersongroup($persongroup = null)
    {
        // validation for constraint: string
        if (!is_null($persongroup) && !is_string($persongroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($persongroup, true), gettype($persongroup)), __LINE__);
        }
        $this->persongroup = $persongroup;
        return $this;
    }
    /**
     * Get paymentInstructions value
     * @return string
     */
    public function getPaymentInstructions()
    {
        return $this->paymentInstructions;
    }
    /**
     * Set paymentInstructions value
     * @param string $paymentInstructions
     * @return \StructType\SERVICE_POSTING
     */
    public function setPaymentInstructions($paymentInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstructions) && !is_string($paymentInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstructions, true), gettype($paymentInstructions)), __LINE__);
        }
        $this->paymentInstructions = $paymentInstructions;
        return $this;
    }
}
