<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SERVICERESTRICTION StructType
 * @subpackage Structs
 */
class SERVICERESTRICTION extends AbstractStructBase
{
    /**
     * The SERVICERESTRICTION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $SERVICERESTRICTION_OBJID;
    /**
     * The SERVICERESTRICTION_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $SERVICERESTRICTION_CENTRALID;
    /**
     * The servicepackage
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $servicepackage;
    /**
     * The roomcategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $roomcategory;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The tobesoldfrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $tobesoldfrom;
    /**
     * The tobesoldto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $tobesoldto;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The additionalinformation
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $additionalinformation;
    /**
     * The closed
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $closed;
    /**
     * The arrivalday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $arrivalday;
    /**
     * The departureday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $departureday;
    /**
     * The resultingin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $resultingin;
    /**
     * The permissableoccupancy
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $permissableoccupancy;
    /**
     * The minstaylength
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $minstaylength;
    /**
     * The maxstaylength
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxstaylength;
    /**
     * The restrictionrhythm
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $restrictionrhythm;
    /**
     * The minnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $minnoofpax;
    /**
     * The maxnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxnoofpax;
    /**
     * The prebooking
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $prebooking;
    /**
     * The prebookingmax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $prebookingmax;
    /**
     * The minstaylengththru
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $minstaylengththru;
    /**
     * The maxstaylengththru
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxstaylengththru;
    /**
     * The NOARRIVALS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NOARRIVALS
     */
    public $NOARRIVALS;
    /**
     * The NODEPARTURES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NODEPARTURES
     */
    public $NODEPARTURES;
    /**
     * The cancellationtype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cancellationtype;
    /**
     * Constructor method for SERVICERESTRICTION
     * @uses SERVICERESTRICTION::setSERVICERESTRICTION_OBJID()
     * @uses SERVICERESTRICTION::setSERVICERESTRICTION_CENTRALID()
     * @uses SERVICERESTRICTION::setServicepackage()
     * @uses SERVICERESTRICTION::setRoomcategory()
     * @uses SERVICERESTRICTION::setDatefrom()
     * @uses SERVICERESTRICTION::setDateto()
     * @uses SERVICERESTRICTION::setTobesoldfrom()
     * @uses SERVICERESTRICTION::setTobesoldto()
     * @uses SERVICERESTRICTION::setComment()
     * @uses SERVICERESTRICTION::setAdditionalinformation()
     * @uses SERVICERESTRICTION::setClosed()
     * @uses SERVICERESTRICTION::setArrivalday()
     * @uses SERVICERESTRICTION::setDepartureday()
     * @uses SERVICERESTRICTION::setResultingin()
     * @uses SERVICERESTRICTION::setPermissableoccupancy()
     * @uses SERVICERESTRICTION::setMinstaylength()
     * @uses SERVICERESTRICTION::setMaxstaylength()
     * @uses SERVICERESTRICTION::setRestrictionrhythm()
     * @uses SERVICERESTRICTION::setMinnoofpax()
     * @uses SERVICERESTRICTION::setMaxnoofpax()
     * @uses SERVICERESTRICTION::setPrebooking()
     * @uses SERVICERESTRICTION::setPrebookingmax()
     * @uses SERVICERESTRICTION::setMinstaylengththru()
     * @uses SERVICERESTRICTION::setMaxstaylengththru()
     * @uses SERVICERESTRICTION::setNOARRIVALS()
     * @uses SERVICERESTRICTION::setNODEPARTURES()
     * @uses SERVICERESTRICTION::setCancellationtype()
     * @param string $sERVICERESTRICTION_OBJID
     * @param string $sERVICERESTRICTION_CENTRALID
     * @param string $servicepackage
     * @param string $roomcategory
     * @param string $datefrom
     * @param string $dateto
     * @param string $tobesoldfrom
     * @param string $tobesoldto
     * @param string $comment
     * @param string $additionalinformation
     * @param string $closed
     * @param string $arrivalday
     * @param string $departureday
     * @param string $resultingin
     * @param string $permissableoccupancy
     * @param string $minstaylength
     * @param string $maxstaylength
     * @param string $restrictionrhythm
     * @param string $minnoofpax
     * @param string $maxnoofpax
     * @param string $prebooking
     * @param string $prebookingmax
     * @param string $minstaylengththru
     * @param string $maxstaylengththru
     * @param \StructType\NOARRIVALS $nOARRIVALS
     * @param \StructType\NODEPARTURES $nODEPARTURES
     * @param string $cancellationtype
     */
    public function __construct($sERVICERESTRICTION_OBJID = null, $sERVICERESTRICTION_CENTRALID = null, $servicepackage = null, $roomcategory = null, $datefrom = null, $dateto = null, $tobesoldfrom = null, $tobesoldto = null, $comment = null, $additionalinformation = null, $closed = null, $arrivalday = null, $departureday = null, $resultingin = null, $permissableoccupancy = null, $minstaylength = null, $maxstaylength = null, $restrictionrhythm = null, $minnoofpax = null, $maxnoofpax = null, $prebooking = null, $prebookingmax = null, $minstaylengththru = null, $maxstaylengththru = null, \StructType\NOARRIVALS $nOARRIVALS = null, \StructType\NODEPARTURES $nODEPARTURES = null, $cancellationtype = null)
    {
        $this
            ->setSERVICERESTRICTION_OBJID($sERVICERESTRICTION_OBJID)
            ->setSERVICERESTRICTION_CENTRALID($sERVICERESTRICTION_CENTRALID)
            ->setServicepackage($servicepackage)
            ->setRoomcategory($roomcategory)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setTobesoldfrom($tobesoldfrom)
            ->setTobesoldto($tobesoldto)
            ->setComment($comment)
            ->setAdditionalinformation($additionalinformation)
            ->setClosed($closed)
            ->setArrivalday($arrivalday)
            ->setDepartureday($departureday)
            ->setResultingin($resultingin)
            ->setPermissableoccupancy($permissableoccupancy)
            ->setMinstaylength($minstaylength)
            ->setMaxstaylength($maxstaylength)
            ->setRestrictionrhythm($restrictionrhythm)
            ->setMinnoofpax($minnoofpax)
            ->setMaxnoofpax($maxnoofpax)
            ->setPrebooking($prebooking)
            ->setPrebookingmax($prebookingmax)
            ->setMinstaylengththru($minstaylengththru)
            ->setMaxstaylengththru($maxstaylengththru)
            ->setNOARRIVALS($nOARRIVALS)
            ->setNODEPARTURES($nODEPARTURES)
            ->setCancellationtype($cancellationtype);
    }
    /**
     * Get SERVICERESTRICTION_OBJID value
     * @return string
     */
    public function getSERVICERESTRICTION_OBJID()
    {
        return $this->{'SERVICERESTRICTION-OBJID'};
    }
    /**
     * Set SERVICERESTRICTION_OBJID value
     * @param string $sERVICERESTRICTION_OBJID
     * @return \StructType\SERVICERESTRICTION
     */
    public function setSERVICERESTRICTION_OBJID($sERVICERESTRICTION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICERESTRICTION_OBJID) && !is_string($sERVICERESTRICTION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICERESTRICTION_OBJID, true), gettype($sERVICERESTRICTION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($sERVICERESTRICTION_OBJID) && !preg_match('/([0-9])*/', $sERVICERESTRICTION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($sERVICERESTRICTION_OBJID, true)), __LINE__);
        }
        $this->SERVICERESTRICTION_OBJID = $this->{'SERVICERESTRICTION-OBJID'} = $sERVICERESTRICTION_OBJID;
        return $this;
    }
    /**
     * Get SERVICERESTRICTION_CENTRALID value
     * @return string
     */
    public function getSERVICERESTRICTION_CENTRALID()
    {
        return $this->{'SERVICERESTRICTION-CENTRALID'};
    }
    /**
     * Set SERVICERESTRICTION_CENTRALID value
     * @param string $sERVICERESTRICTION_CENTRALID
     * @return \StructType\SERVICERESTRICTION
     */
    public function setSERVICERESTRICTION_CENTRALID($sERVICERESTRICTION_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICERESTRICTION_CENTRALID) && !is_string($sERVICERESTRICTION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICERESTRICTION_CENTRALID, true), gettype($sERVICERESTRICTION_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($sERVICERESTRICTION_CENTRALID) && !preg_match('/([0-9])*/', $sERVICERESTRICTION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($sERVICERESTRICTION_CENTRALID, true)), __LINE__);
        }
        $this->SERVICERESTRICTION_CENTRALID = $this->{'SERVICERESTRICTION-CENTRALID'} = $sERVICERESTRICTION_CENTRALID;
        return $this;
    }
    /**
     * Get servicepackage value
     * @return string
     */
    public function getServicepackage()
    {
        return $this->servicepackage;
    }
    /**
     * Set servicepackage value
     * @param string $servicepackage
     * @return \StructType\SERVICERESTRICTION
     */
    public function setServicepackage($servicepackage = null)
    {
        // validation for constraint: string
        if (!is_null($servicepackage) && !is_string($servicepackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicepackage, true), gettype($servicepackage)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($servicepackage) && mb_strlen($servicepackage) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($servicepackage)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($servicepackage) && mb_strlen($servicepackage) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($servicepackage)), __LINE__);
        }
        $this->servicepackage = $servicepackage;
        return $this;
    }
    /**
     * Get roomcategory value
     * @return string
     */
    public function getRoomcategory()
    {
        return $this->roomcategory;
    }
    /**
     * Set roomcategory value
     * @param string $roomcategory
     * @return \StructType\SERVICERESTRICTION
     */
    public function setRoomcategory($roomcategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomcategory) && !is_string($roomcategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomcategory, true), gettype($roomcategory)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($roomcategory) && mb_strlen($roomcategory) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($roomcategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($roomcategory) && mb_strlen($roomcategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($roomcategory)), __LINE__);
        }
        $this->roomcategory = $roomcategory;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\SERVICERESTRICTION
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\SERVICERESTRICTION
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get tobesoldfrom value
     * @return string
     */
    public function getTobesoldfrom()
    {
        return $this->tobesoldfrom;
    }
    /**
     * Set tobesoldfrom value
     * @param string $tobesoldfrom
     * @return \StructType\SERVICERESTRICTION
     */
    public function setTobesoldfrom($tobesoldfrom = null)
    {
        // validation for constraint: string
        if (!is_null($tobesoldfrom) && !is_string($tobesoldfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tobesoldfrom, true), gettype($tobesoldfrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($tobesoldfrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $tobesoldfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($tobesoldfrom, true)), __LINE__);
        }
        $this->tobesoldfrom = $tobesoldfrom;
        return $this;
    }
    /**
     * Get tobesoldto value
     * @return string
     */
    public function getTobesoldto()
    {
        return $this->tobesoldto;
    }
    /**
     * Set tobesoldto value
     * @param string $tobesoldto
     * @return \StructType\SERVICERESTRICTION
     */
    public function setTobesoldto($tobesoldto = null)
    {
        // validation for constraint: string
        if (!is_null($tobesoldto) && !is_string($tobesoldto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tobesoldto, true), gettype($tobesoldto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($tobesoldto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $tobesoldto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($tobesoldto, true)), __LINE__);
        }
        $this->tobesoldto = $tobesoldto;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\SERVICERESTRICTION
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($comment) && mb_strlen($comment) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($comment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($comment) && mb_strlen($comment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get additionalinformation value
     * @return string
     */
    public function getAdditionalinformation()
    {
        return $this->additionalinformation;
    }
    /**
     * Set additionalinformation value
     * @param string $additionalinformation
     * @return \StructType\SERVICERESTRICTION
     */
    public function setAdditionalinformation($additionalinformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalinformation) && !is_string($additionalinformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalinformation, true), gettype($additionalinformation)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($additionalinformation) && mb_strlen($additionalinformation) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($additionalinformation)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($additionalinformation) && mb_strlen($additionalinformation) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($additionalinformation)), __LINE__);
        }
        $this->additionalinformation = $additionalinformation;
        return $this;
    }
    /**
     * Get closed value
     * @return string
     */
    public function getClosed()
    {
        return $this->closed;
    }
    /**
     * Set closed value
     * @param string $closed
     * @return \StructType\SERVICERESTRICTION
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: string
        if (!is_null($closed) && !is_string($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closed, true), gettype($closed)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($closed) && !preg_match('/([-+]){0,1}([0-9])*/', $closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($closed, true)), __LINE__);
        }
        $this->closed = $closed;
        return $this;
    }
    /**
     * Get arrivalday value
     * @return string
     */
    public function getArrivalday()
    {
        return $this->arrivalday;
    }
    /**
     * Set arrivalday value
     * @param string $arrivalday
     * @return \StructType\SERVICERESTRICTION
     */
    public function setArrivalday($arrivalday = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalday) && !is_string($arrivalday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalday, true), gettype($arrivalday)), __LINE__);
        }
        $this->arrivalday = $arrivalday;
        return $this;
    }
    /**
     * Get departureday value
     * @return string
     */
    public function getDepartureday()
    {
        return $this->departureday;
    }
    /**
     * Set departureday value
     * @param string $departureday
     * @return \StructType\SERVICERESTRICTION
     */
    public function setDepartureday($departureday = null)
    {
        // validation for constraint: string
        if (!is_null($departureday) && !is_string($departureday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureday, true), gettype($departureday)), __LINE__);
        }
        $this->departureday = $departureday;
        return $this;
    }
    /**
     * Get resultingin value
     * @return string
     */
    public function getResultingin()
    {
        return $this->resultingin;
    }
    /**
     * Set resultingin value
     * @param string $resultingin
     * @return \StructType\SERVICERESTRICTION
     */
    public function setResultingin($resultingin = null)
    {
        // validation for constraint: string
        if (!is_null($resultingin) && !is_string($resultingin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultingin, true), gettype($resultingin)), __LINE__);
        }
        $this->resultingin = $resultingin;
        return $this;
    }
    /**
     * Get permissableoccupancy value
     * @return string
     */
    public function getPermissableoccupancy()
    {
        return $this->permissableoccupancy;
    }
    /**
     * Set permissableoccupancy value
     * @param string $permissableoccupancy
     * @return \StructType\SERVICERESTRICTION
     */
    public function setPermissableoccupancy($permissableoccupancy = null)
    {
        // validation for constraint: string
        if (!is_null($permissableoccupancy) && !is_string($permissableoccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($permissableoccupancy, true), gettype($permissableoccupancy)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($permissableoccupancy) && !preg_match('/([-+]){0,1}([0-9])*/', $permissableoccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($permissableoccupancy, true)), __LINE__);
        }
        $this->permissableoccupancy = $permissableoccupancy;
        return $this;
    }
    /**
     * Get minstaylength value
     * @return string
     */
    public function getMinstaylength()
    {
        return $this->minstaylength;
    }
    /**
     * Set minstaylength value
     * @param string $minstaylength
     * @return \StructType\SERVICERESTRICTION
     */
    public function setMinstaylength($minstaylength = null)
    {
        // validation for constraint: string
        if (!is_null($minstaylength) && !is_string($minstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minstaylength, true), gettype($minstaylength)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($minstaylength) && !preg_match('/([-+]){0,1}([0-9])*/', $minstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($minstaylength, true)), __LINE__);
        }
        $this->minstaylength = $minstaylength;
        return $this;
    }
    /**
     * Get maxstaylength value
     * @return string
     */
    public function getMaxstaylength()
    {
        return $this->maxstaylength;
    }
    /**
     * Set maxstaylength value
     * @param string $maxstaylength
     * @return \StructType\SERVICERESTRICTION
     */
    public function setMaxstaylength($maxstaylength = null)
    {
        // validation for constraint: string
        if (!is_null($maxstaylength) && !is_string($maxstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxstaylength, true), gettype($maxstaylength)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxstaylength) && !preg_match('/([-+]){0,1}([0-9])*/', $maxstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxstaylength, true)), __LINE__);
        }
        $this->maxstaylength = $maxstaylength;
        return $this;
    }
    /**
     * Get restrictionrhythm value
     * @return string
     */
    public function getRestrictionrhythm()
    {
        return $this->restrictionrhythm;
    }
    /**
     * Set restrictionrhythm value
     * @param string $restrictionrhythm
     * @return \StructType\SERVICERESTRICTION
     */
    public function setRestrictionrhythm($restrictionrhythm = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionrhythm) && !is_string($restrictionrhythm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionrhythm, true), gettype($restrictionrhythm)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($restrictionrhythm) && mb_strlen($restrictionrhythm) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($restrictionrhythm)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($restrictionrhythm) && mb_strlen($restrictionrhythm) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($restrictionrhythm)), __LINE__);
        }
        $this->restrictionrhythm = $restrictionrhythm;
        return $this;
    }
    /**
     * Get minnoofpax value
     * @return string
     */
    public function getMinnoofpax()
    {
        return $this->minnoofpax;
    }
    /**
     * Set minnoofpax value
     * @param string $minnoofpax
     * @return \StructType\SERVICERESTRICTION
     */
    public function setMinnoofpax($minnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($minnoofpax) && !is_string($minnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minnoofpax, true), gettype($minnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($minnoofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $minnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($minnoofpax, true)), __LINE__);
        }
        $this->minnoofpax = $minnoofpax;
        return $this;
    }
    /**
     * Get maxnoofpax value
     * @return string
     */
    public function getMaxnoofpax()
    {
        return $this->maxnoofpax;
    }
    /**
     * Set maxnoofpax value
     * @param string $maxnoofpax
     * @return \StructType\SERVICERESTRICTION
     */
    public function setMaxnoofpax($maxnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($maxnoofpax) && !is_string($maxnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxnoofpax, true), gettype($maxnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxnoofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $maxnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxnoofpax, true)), __LINE__);
        }
        $this->maxnoofpax = $maxnoofpax;
        return $this;
    }
    /**
     * Get prebooking value
     * @return string
     */
    public function getPrebooking()
    {
        return $this->prebooking;
    }
    /**
     * Set prebooking value
     * @param string $prebooking
     * @return \StructType\SERVICERESTRICTION
     */
    public function setPrebooking($prebooking = null)
    {
        // validation for constraint: string
        if (!is_null($prebooking) && !is_string($prebooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prebooking, true), gettype($prebooking)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($prebooking) && !preg_match('/([-+]){0,1}([0-9])*/', $prebooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($prebooking, true)), __LINE__);
        }
        $this->prebooking = $prebooking;
        return $this;
    }
    /**
     * Get prebookingmax value
     * @return string
     */
    public function getPrebookingmax()
    {
        return $this->prebookingmax;
    }
    /**
     * Set prebookingmax value
     * @param string $prebookingmax
     * @return \StructType\SERVICERESTRICTION
     */
    public function setPrebookingmax($prebookingmax = null)
    {
        // validation for constraint: string
        if (!is_null($prebookingmax) && !is_string($prebookingmax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prebookingmax, true), gettype($prebookingmax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($prebookingmax) && !preg_match('/([-+]){0,1}([0-9])*/', $prebookingmax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($prebookingmax, true)), __LINE__);
        }
        $this->prebookingmax = $prebookingmax;
        return $this;
    }
    /**
     * Get minstaylengththru value
     * @return string
     */
    public function getMinstaylengththru()
    {
        return $this->minstaylengththru;
    }
    /**
     * Set minstaylengththru value
     * @param string $minstaylengththru
     * @return \StructType\SERVICERESTRICTION
     */
    public function setMinstaylengththru($minstaylengththru = null)
    {
        // validation for constraint: string
        if (!is_null($minstaylengththru) && !is_string($minstaylengththru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minstaylengththru, true), gettype($minstaylengththru)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($minstaylengththru) && !preg_match('/([-+]){0,1}([0-9])*/', $minstaylengththru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($minstaylengththru, true)), __LINE__);
        }
        $this->minstaylengththru = $minstaylengththru;
        return $this;
    }
    /**
     * Get maxstaylengththru value
     * @return string
     */
    public function getMaxstaylengththru()
    {
        return $this->maxstaylengththru;
    }
    /**
     * Set maxstaylengththru value
     * @param string $maxstaylengththru
     * @return \StructType\SERVICERESTRICTION
     */
    public function setMaxstaylengththru($maxstaylengththru = null)
    {
        // validation for constraint: string
        if (!is_null($maxstaylengththru) && !is_string($maxstaylengththru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxstaylengththru, true), gettype($maxstaylengththru)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxstaylengththru) && !preg_match('/([-+]){0,1}([0-9])*/', $maxstaylengththru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxstaylengththru, true)), __LINE__);
        }
        $this->maxstaylengththru = $maxstaylengththru;
        return $this;
    }
    /**
     * Get NOARRIVALS value
     * @return \StructType\NOARRIVALS
     */
    public function getNOARRIVALS()
    {
        return $this->NOARRIVALS;
    }
    /**
     * Set NOARRIVALS value
     * @param \StructType\NOARRIVALS $nOARRIVALS
     * @return \StructType\SERVICERESTRICTION
     */
    public function setNOARRIVALS(\StructType\NOARRIVALS $nOARRIVALS = null)
    {
        $this->NOARRIVALS = $nOARRIVALS;
        return $this;
    }
    /**
     * Get NODEPARTURES value
     * @return \StructType\NODEPARTURES
     */
    public function getNODEPARTURES()
    {
        return $this->NODEPARTURES;
    }
    /**
     * Set NODEPARTURES value
     * @param \StructType\NODEPARTURES $nODEPARTURES
     * @return \StructType\SERVICERESTRICTION
     */
    public function setNODEPARTURES(\StructType\NODEPARTURES $nODEPARTURES = null)
    {
        $this->NODEPARTURES = $nODEPARTURES;
        return $this;
    }
    /**
     * Get cancellationtype value
     * @return string
     */
    public function getCancellationtype()
    {
        return $this->cancellationtype;
    }
    /**
     * Set cancellationtype value
     * @param string $cancellationtype
     * @return \StructType\SERVICERESTRICTION
     */
    public function setCancellationtype($cancellationtype = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationtype) && !is_string($cancellationtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationtype, true), gettype($cancellationtype)), __LINE__);
        }
        $this->cancellationtype = $cancellationtype;
        return $this;
    }
}
