<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SEARCH StructType
 * @subpackage Structs
 */
class SEARCH_1 extends AbstractStructBase
{
    /**
     * The housekeepingstatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $housekeepingstatus;
    /**
     * The floor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $floor;
    /**
     * The vip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vip;
    /**
     * The hskarea
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hskarea;
    /**
     * The shift
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shift;
    /**
     * The hskservices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hskservices;
    /**
     * The hoteldate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $hoteldate;
    /**
     * The roomno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roomno;
    /**
     * Constructor method for SEARCH
     * @uses SEARCH_1::setHousekeepingstatus()
     * @uses SEARCH_1::setFloor()
     * @uses SEARCH_1::setVip()
     * @uses SEARCH_1::setHskarea()
     * @uses SEARCH_1::setShift()
     * @uses SEARCH_1::setHskservices()
     * @uses SEARCH_1::setHoteldate()
     * @uses SEARCH_1::setRoomno()
     * @param string $housekeepingstatus
     * @param string $floor
     * @param string $vip
     * @param string $hskarea
     * @param string $shift
     * @param string $hskservices
     * @param string $hoteldate
     * @param string $roomno
     */
    public function __construct($housekeepingstatus = null, $floor = null, $vip = null, $hskarea = null, $shift = null, $hskservices = null, $hoteldate = null, $roomno = null)
    {
        $this
            ->setHousekeepingstatus($housekeepingstatus)
            ->setFloor($floor)
            ->setVip($vip)
            ->setHskarea($hskarea)
            ->setShift($shift)
            ->setHskservices($hskservices)
            ->setHoteldate($hoteldate)
            ->setRoomno($roomno);
    }
    /**
     * Get housekeepingstatus value
     * @return string|null
     */
    public function getHousekeepingstatus()
    {
        return $this->housekeepingstatus;
    }
    /**
     * Set housekeepingstatus value
     * @param string $housekeepingstatus
     * @return \StructType\SEARCH_1
     */
    public function setHousekeepingstatus($housekeepingstatus = null)
    {
        // validation for constraint: string
        if (!is_null($housekeepingstatus) && !is_string($housekeepingstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeepingstatus, true), gettype($housekeepingstatus)), __LINE__);
        }
        $this->housekeepingstatus = $housekeepingstatus;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \StructType\SEARCH_1
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get vip value
     * @return string|null
     */
    public function getVip()
    {
        return $this->vip;
    }
    /**
     * Set vip value
     * @param string $vip
     * @return \StructType\SEARCH_1
     */
    public function setVip($vip = null)
    {
        // validation for constraint: string
        if (!is_null($vip) && !is_string($vip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip, true), gettype($vip)), __LINE__);
        }
        $this->vip = $vip;
        return $this;
    }
    /**
     * Get hskarea value
     * @return string|null
     */
    public function getHskarea()
    {
        return $this->hskarea;
    }
    /**
     * Set hskarea value
     * @param string $hskarea
     * @return \StructType\SEARCH_1
     */
    public function setHskarea($hskarea = null)
    {
        // validation for constraint: string
        if (!is_null($hskarea) && !is_string($hskarea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hskarea, true), gettype($hskarea)), __LINE__);
        }
        $this->hskarea = $hskarea;
        return $this;
    }
    /**
     * Get shift value
     * @return string|null
     */
    public function getShift()
    {
        return $this->shift;
    }
    /**
     * Set shift value
     * @param string $shift
     * @return \StructType\SEARCH_1
     */
    public function setShift($shift = null)
    {
        // validation for constraint: string
        if (!is_null($shift) && !is_string($shift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shift, true), gettype($shift)), __LINE__);
        }
        $this->shift = $shift;
        return $this;
    }
    /**
     * Get hskservices value
     * @return string|null
     */
    public function getHskservices()
    {
        return $this->hskservices;
    }
    /**
     * Set hskservices value
     * @param string $hskservices
     * @return \StructType\SEARCH_1
     */
    public function setHskservices($hskservices = null)
    {
        // validation for constraint: string
        if (!is_null($hskservices) && !is_string($hskservices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hskservices, true), gettype($hskservices)), __LINE__);
        }
        $this->hskservices = $hskservices;
        return $this;
    }
    /**
     * Get hoteldate value
     * @return string|null
     */
    public function getHoteldate()
    {
        return $this->hoteldate;
    }
    /**
     * Set hoteldate value
     * @param string $hoteldate
     * @return \StructType\SEARCH_1
     */
    public function setHoteldate($hoteldate = null)
    {
        // validation for constraint: string
        if (!is_null($hoteldate) && !is_string($hoteldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoteldate, true), gettype($hoteldate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($hoteldate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $hoteldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($hoteldate, true)), __LINE__);
        }
        $this->hoteldate = $hoteldate;
        return $this;
    }
    /**
     * Get roomno value
     * @return string|null
     */
    public function getRoomno()
    {
        return $this->roomno;
    }
    /**
     * Set roomno value
     * @param string $roomno
     * @return \StructType\SEARCH_1
     */
    public function setRoomno($roomno = null)
    {
        // validation for constraint: string
        if (!is_null($roomno) && !is_string($roomno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomno, true), gettype($roomno)), __LINE__);
        }
        $this->roomno = $roomno;
        return $this;
    }
}
