<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomSearch StructType
 * @subpackage Structs
 */
class RoomSearch extends AbstractStructBase
{
    /**
     * The RoomBookingFree
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomBookingFree
     */
    public $RoomBookingFree;
    /**
     * The RoomBookingStateModifyOOI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomBookingStateModifyOOI
     */
    public $RoomBookingStateModifyOOI;
    /**
     * The RoomBookingOOI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomBookingOOI
     */
    public $RoomBookingOOI;
    /**
     * The RoomBookingStateModifyOOO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomBookingStateModifyOOO
     */
    public $RoomBookingStateModifyOOO;
    /**
     * The RoomBookingOOS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomBookingOOS
     */
    public $RoomBookingOOS;
    /**
     * The RoomBookingOOO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomBookingOOO
     */
    public $RoomBookingOOO;
    /**
     * The RoomBookingStateModifyOOS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomBookingStateModifyOOS
     */
    public $RoomBookingStateModifyOOS;
    /**
     * The ROOM_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_OBJID;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $room;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $category;
    /**
     * The floor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $floor;
    /**
     * The housekeeping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $housekeeping;
    /**
     * The maintenance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maintenance;
    /**
     * The roomfrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roomfrom;
    /**
     * The roomto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roomto;
    /**
     * The roomlocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roomlocation;
    /**
     * The feature1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $feature1;
    /**
     * The feature2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $feature2;
    /**
     * The building
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $building;
    /**
     * Constructor method for RoomSearch
     * @uses RoomSearch::setRoomBookingFree()
     * @uses RoomSearch::setRoomBookingStateModifyOOI()
     * @uses RoomSearch::setRoomBookingOOI()
     * @uses RoomSearch::setRoomBookingStateModifyOOO()
     * @uses RoomSearch::setRoomBookingOOS()
     * @uses RoomSearch::setRoomBookingOOO()
     * @uses RoomSearch::setRoomBookingStateModifyOOS()
     * @uses RoomSearch::setROOM_OBJID()
     * @uses RoomSearch::setDatefrom()
     * @uses RoomSearch::setDateto()
     * @uses RoomSearch::setRoom()
     * @uses RoomSearch::setCategory()
     * @uses RoomSearch::setFloor()
     * @uses RoomSearch::setHousekeeping()
     * @uses RoomSearch::setMaintenance()
     * @uses RoomSearch::setRoomfrom()
     * @uses RoomSearch::setRoomto()
     * @uses RoomSearch::setRoomlocation()
     * @uses RoomSearch::setFeature1()
     * @uses RoomSearch::setFeature2()
     * @uses RoomSearch::setBuilding()
     * @param \StructType\RoomBookingFree $roomBookingFree
     * @param \StructType\RoomBookingStateModifyOOI $roomBookingStateModifyOOI
     * @param \StructType\RoomBookingOOI $roomBookingOOI
     * @param \StructType\RoomBookingStateModifyOOO $roomBookingStateModifyOOO
     * @param \StructType\RoomBookingOOS $roomBookingOOS
     * @param \StructType\RoomBookingOOO $roomBookingOOO
     * @param \StructType\RoomBookingStateModifyOOS $roomBookingStateModifyOOS
     * @param string $rOOM_OBJID
     * @param string $datefrom
     * @param string $dateto
     * @param string $room
     * @param string $category
     * @param string $floor
     * @param string $housekeeping
     * @param string $maintenance
     * @param string $roomfrom
     * @param string $roomto
     * @param string $roomlocation
     * @param string $feature1
     * @param string $feature2
     * @param string $building
     */
    public function __construct(\StructType\RoomBookingFree $roomBookingFree = null, \StructType\RoomBookingStateModifyOOI $roomBookingStateModifyOOI = null, \StructType\RoomBookingOOI $roomBookingOOI = null, \StructType\RoomBookingStateModifyOOO $roomBookingStateModifyOOO = null, \StructType\RoomBookingOOS $roomBookingOOS = null, \StructType\RoomBookingOOO $roomBookingOOO = null, \StructType\RoomBookingStateModifyOOS $roomBookingStateModifyOOS = null, $rOOM_OBJID = null, $datefrom = null, $dateto = null, $room = null, $category = null, $floor = null, $housekeeping = null, $maintenance = null, $roomfrom = null, $roomto = null, $roomlocation = null, $feature1 = null, $feature2 = null, $building = null)
    {
        $this
            ->setRoomBookingFree($roomBookingFree)
            ->setRoomBookingStateModifyOOI($roomBookingStateModifyOOI)
            ->setRoomBookingOOI($roomBookingOOI)
            ->setRoomBookingStateModifyOOO($roomBookingStateModifyOOO)
            ->setRoomBookingOOS($roomBookingOOS)
            ->setRoomBookingOOO($roomBookingOOO)
            ->setRoomBookingStateModifyOOS($roomBookingStateModifyOOS)
            ->setROOM_OBJID($rOOM_OBJID)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setRoom($room)
            ->setCategory($category)
            ->setFloor($floor)
            ->setHousekeeping($housekeeping)
            ->setMaintenance($maintenance)
            ->setRoomfrom($roomfrom)
            ->setRoomto($roomto)
            ->setRoomlocation($roomlocation)
            ->setFeature1($feature1)
            ->setFeature2($feature2)
            ->setBuilding($building);
    }
    /**
     * Get RoomBookingFree value
     * @return \StructType\RoomBookingFree
     */
    public function getRoomBookingFree()
    {
        return $this->RoomBookingFree;
    }
    /**
     * Set RoomBookingFree value
     * @param \StructType\RoomBookingFree $roomBookingFree
     * @return \StructType\RoomSearch
     */
    public function setRoomBookingFree(\StructType\RoomBookingFree $roomBookingFree = null)
    {
        $this->RoomBookingFree = $roomBookingFree;
        return $this;
    }
    /**
     * Get RoomBookingStateModifyOOI value
     * @return \StructType\RoomBookingStateModifyOOI
     */
    public function getRoomBookingStateModifyOOI()
    {
        return $this->RoomBookingStateModifyOOI;
    }
    /**
     * Set RoomBookingStateModifyOOI value
     * @param \StructType\RoomBookingStateModifyOOI $roomBookingStateModifyOOI
     * @return \StructType\RoomSearch
     */
    public function setRoomBookingStateModifyOOI(\StructType\RoomBookingStateModifyOOI $roomBookingStateModifyOOI = null)
    {
        $this->RoomBookingStateModifyOOI = $roomBookingStateModifyOOI;
        return $this;
    }
    /**
     * Get RoomBookingOOI value
     * @return \StructType\RoomBookingOOI
     */
    public function getRoomBookingOOI()
    {
        return $this->RoomBookingOOI;
    }
    /**
     * Set RoomBookingOOI value
     * @param \StructType\RoomBookingOOI $roomBookingOOI
     * @return \StructType\RoomSearch
     */
    public function setRoomBookingOOI(\StructType\RoomBookingOOI $roomBookingOOI = null)
    {
        $this->RoomBookingOOI = $roomBookingOOI;
        return $this;
    }
    /**
     * Get RoomBookingStateModifyOOO value
     * @return \StructType\RoomBookingStateModifyOOO
     */
    public function getRoomBookingStateModifyOOO()
    {
        return $this->RoomBookingStateModifyOOO;
    }
    /**
     * Set RoomBookingStateModifyOOO value
     * @param \StructType\RoomBookingStateModifyOOO $roomBookingStateModifyOOO
     * @return \StructType\RoomSearch
     */
    public function setRoomBookingStateModifyOOO(\StructType\RoomBookingStateModifyOOO $roomBookingStateModifyOOO = null)
    {
        $this->RoomBookingStateModifyOOO = $roomBookingStateModifyOOO;
        return $this;
    }
    /**
     * Get RoomBookingOOS value
     * @return \StructType\RoomBookingOOS
     */
    public function getRoomBookingOOS()
    {
        return $this->RoomBookingOOS;
    }
    /**
     * Set RoomBookingOOS value
     * @param \StructType\RoomBookingOOS $roomBookingOOS
     * @return \StructType\RoomSearch
     */
    public function setRoomBookingOOS(\StructType\RoomBookingOOS $roomBookingOOS = null)
    {
        $this->RoomBookingOOS = $roomBookingOOS;
        return $this;
    }
    /**
     * Get RoomBookingOOO value
     * @return \StructType\RoomBookingOOO
     */
    public function getRoomBookingOOO()
    {
        return $this->RoomBookingOOO;
    }
    /**
     * Set RoomBookingOOO value
     * @param \StructType\RoomBookingOOO $roomBookingOOO
     * @return \StructType\RoomSearch
     */
    public function setRoomBookingOOO(\StructType\RoomBookingOOO $roomBookingOOO = null)
    {
        $this->RoomBookingOOO = $roomBookingOOO;
        return $this;
    }
    /**
     * Get RoomBookingStateModifyOOS value
     * @return \StructType\RoomBookingStateModifyOOS
     */
    public function getRoomBookingStateModifyOOS()
    {
        return $this->RoomBookingStateModifyOOS;
    }
    /**
     * Set RoomBookingStateModifyOOS value
     * @param \StructType\RoomBookingStateModifyOOS $roomBookingStateModifyOOS
     * @return \StructType\RoomSearch
     */
    public function setRoomBookingStateModifyOOS(\StructType\RoomBookingStateModifyOOS $roomBookingStateModifyOOS = null)
    {
        $this->RoomBookingStateModifyOOS = $roomBookingStateModifyOOS;
        return $this;
    }
    /**
     * Get ROOM_OBJID value
     * @return string
     */
    public function getROOM_OBJID()
    {
        return $this->{'ROOM-OBJID'};
    }
    /**
     * Set ROOM_OBJID value
     * @param string $rOOM_OBJID
     * @return \StructType\RoomSearch
     */
    public function setROOM_OBJID($rOOM_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_OBJID) && !is_string($rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_OBJID, true), gettype($rOOM_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_OBJID) && !preg_match('/([0-9])*/', $rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_OBJID, true)), __LINE__);
        }
        $this->ROOM_OBJID = $this->{'ROOM-OBJID'} = $rOOM_OBJID;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\RoomSearch
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\RoomSearch
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get room value
     * @return string|null
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\RoomSearch
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\RoomSearch
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \StructType\RoomSearch
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get housekeeping value
     * @return string|null
     */
    public function getHousekeeping()
    {
        return $this->housekeeping;
    }
    /**
     * Set housekeeping value
     * @param string $housekeeping
     * @return \StructType\RoomSearch
     */
    public function setHousekeeping($housekeeping = null)
    {
        // validation for constraint: string
        if (!is_null($housekeeping) && !is_string($housekeeping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeeping, true), gettype($housekeeping)), __LINE__);
        }
        $this->housekeeping = $housekeeping;
        return $this;
    }
    /**
     * Get maintenance value
     * @return string|null
     */
    public function getMaintenance()
    {
        return $this->maintenance;
    }
    /**
     * Set maintenance value
     * @param string $maintenance
     * @return \StructType\RoomSearch
     */
    public function setMaintenance($maintenance = null)
    {
        // validation for constraint: string
        if (!is_null($maintenance) && !is_string($maintenance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenance, true), gettype($maintenance)), __LINE__);
        }
        $this->maintenance = $maintenance;
        return $this;
    }
    /**
     * Get roomfrom value
     * @return string|null
     */
    public function getRoomfrom()
    {
        return $this->roomfrom;
    }
    /**
     * Set roomfrom value
     * @param string $roomfrom
     * @return \StructType\RoomSearch
     */
    public function setRoomfrom($roomfrom = null)
    {
        // validation for constraint: string
        if (!is_null($roomfrom) && !is_string($roomfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomfrom, true), gettype($roomfrom)), __LINE__);
        }
        $this->roomfrom = $roomfrom;
        return $this;
    }
    /**
     * Get roomto value
     * @return string|null
     */
    public function getRoomto()
    {
        return $this->roomto;
    }
    /**
     * Set roomto value
     * @param string $roomto
     * @return \StructType\RoomSearch
     */
    public function setRoomto($roomto = null)
    {
        // validation for constraint: string
        if (!is_null($roomto) && !is_string($roomto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomto, true), gettype($roomto)), __LINE__);
        }
        $this->roomto = $roomto;
        return $this;
    }
    /**
     * Get roomlocation value
     * @return string|null
     */
    public function getRoomlocation()
    {
        return $this->roomlocation;
    }
    /**
     * Set roomlocation value
     * @param string $roomlocation
     * @return \StructType\RoomSearch
     */
    public function setRoomlocation($roomlocation = null)
    {
        // validation for constraint: string
        if (!is_null($roomlocation) && !is_string($roomlocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomlocation, true), gettype($roomlocation)), __LINE__);
        }
        $this->roomlocation = $roomlocation;
        return $this;
    }
    /**
     * Get feature1 value
     * @return string|null
     */
    public function getFeature1()
    {
        return $this->feature1;
    }
    /**
     * Set feature1 value
     * @param string $feature1
     * @return \StructType\RoomSearch
     */
    public function setFeature1($feature1 = null)
    {
        // validation for constraint: string
        if (!is_null($feature1) && !is_string($feature1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature1, true), gettype($feature1)), __LINE__);
        }
        $this->feature1 = $feature1;
        return $this;
    }
    /**
     * Get feature2 value
     * @return string|null
     */
    public function getFeature2()
    {
        return $this->feature2;
    }
    /**
     * Set feature2 value
     * @param string $feature2
     * @return \StructType\RoomSearch
     */
    public function setFeature2($feature2 = null)
    {
        // validation for constraint: string
        if (!is_null($feature2) && !is_string($feature2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature2, true), gettype($feature2)), __LINE__);
        }
        $this->feature2 = $feature2;
        return $this;
    }
    /**
     * Get building value
     * @return string|null
     */
    public function getBuilding()
    {
        return $this->building;
    }
    /**
     * Set building value
     * @param string $building
     * @return \StructType\RoomSearch
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building, true), gettype($building)), __LINE__);
        }
        $this->building = $building;
        return $this;
    }
}
