<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomHousekeepingStatus StructType
 * @subpackage Structs
 */
class RoomHousekeepingStatus extends AbstractStructBase
{
    /**
     * The ROOMHOUSEKEEPINGSTATUS_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMHOUSEKEEPINGSTATUS_OBJID;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $time;
    /**
     * The staffno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 8
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $staffno;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $user;
    /**
     * The housekeepingstatus
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $housekeepingstatus;
    /**
     * Constructor method for RoomHousekeepingStatus
     * @uses RoomHousekeepingStatus::setROOMHOUSEKEEPINGSTATUS_OBJID()
     * @uses RoomHousekeepingStatus::setDate()
     * @uses RoomHousekeepingStatus::setTime()
     * @uses RoomHousekeepingStatus::setStaffno()
     * @uses RoomHousekeepingStatus::setUser()
     * @uses RoomHousekeepingStatus::setHousekeepingstatus()
     * @param string $rOOMHOUSEKEEPINGSTATUS_OBJID
     * @param string $date
     * @param string $time
     * @param string $staffno
     * @param string $user
     * @param string $housekeepingstatus
     */
    public function __construct($rOOMHOUSEKEEPINGSTATUS_OBJID = null, $date = null, $time = null, $staffno = null, $user = null, $housekeepingstatus = null)
    {
        $this
            ->setROOMHOUSEKEEPINGSTATUS_OBJID($rOOMHOUSEKEEPINGSTATUS_OBJID)
            ->setDate($date)
            ->setTime($time)
            ->setStaffno($staffno)
            ->setUser($user)
            ->setHousekeepingstatus($housekeepingstatus);
    }
    /**
     * Get ROOMHOUSEKEEPINGSTATUS_OBJID value
     * @return string
     */
    public function getROOMHOUSEKEEPINGSTATUS_OBJID()
    {
        return $this->{'ROOMHOUSEKEEPINGSTATUS-OBJID'};
    }
    /**
     * Set ROOMHOUSEKEEPINGSTATUS_OBJID value
     * @param string $rOOMHOUSEKEEPINGSTATUS_OBJID
     * @return \StructType\RoomHousekeepingStatus
     */
    public function setROOMHOUSEKEEPINGSTATUS_OBJID($rOOMHOUSEKEEPINGSTATUS_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMHOUSEKEEPINGSTATUS_OBJID) && !is_string($rOOMHOUSEKEEPINGSTATUS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMHOUSEKEEPINGSTATUS_OBJID, true), gettype($rOOMHOUSEKEEPINGSTATUS_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMHOUSEKEEPINGSTATUS_OBJID) && !preg_match('/([0-9])*/', $rOOMHOUSEKEEPINGSTATUS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMHOUSEKEEPINGSTATUS_OBJID, true)), __LINE__);
        }
        $this->ROOMHOUSEKEEPINGSTATUS_OBJID = $this->{'ROOMHOUSEKEEPINGSTATUS-OBJID'} = $rOOMHOUSEKEEPINGSTATUS_OBJID;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\RoomHousekeepingStatus
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get time value
     * @return string
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\RoomHousekeepingStatus
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($time) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($time, true)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get staffno value
     * @return string
     */
    public function getStaffno()
    {
        return $this->staffno;
    }
    /**
     * Set staffno value
     * @param string $staffno
     * @return \StructType\RoomHousekeepingStatus
     */
    public function setStaffno($staffno = null)
    {
        // validation for constraint: string
        if (!is_null($staffno) && !is_string($staffno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($staffno, true), gettype($staffno)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($staffno) && mb_strlen($staffno) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($staffno)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($staffno) && mb_strlen($staffno) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($staffno)), __LINE__);
        }
        $this->staffno = $staffno;
        return $this;
    }
    /**
     * Get user value
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\RoomHousekeepingStatus
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get housekeepingstatus value
     * @return string
     */
    public function getHousekeepingstatus()
    {
        return $this->housekeepingstatus;
    }
    /**
     * Set housekeepingstatus value
     * @param string $housekeepingstatus
     * @return \StructType\RoomHousekeepingStatus
     */
    public function setHousekeepingstatus($housekeepingstatus = null)
    {
        // validation for constraint: string
        if (!is_null($housekeepingstatus) && !is_string($housekeepingstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeepingstatus, true), gettype($housekeepingstatus)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($housekeepingstatus) && mb_strlen($housekeepingstatus) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($housekeepingstatus)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($housekeepingstatus) && mb_strlen($housekeepingstatus) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($housekeepingstatus)), __LINE__);
        }
        $this->housekeepingstatus = $housekeepingstatus;
        return $this;
    }
}
