<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomCategoryMasterFile StructType
 * @subpackage Structs
 */
class RoomCategoryMasterFile extends AbstractStructBase
{
    /**
     * The ROOM_CATEGORY_MASTER_FILE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_CATEGORY_MASTER_FILE_OBJID;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The MultiLangDescriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangDescriptions[]
     */
    public $MultiLangDescriptions;
    /**
     * The MultiLangComments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangComments[]
     */
    public $MultiLangComments;
    /**
     * The MultiLangComments2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangComments2[]
     */
    public $MultiLangComments2;
    /**
     * Constructor method for RoomCategoryMasterFile
     * @uses RoomCategoryMasterFile::setROOM_CATEGORY_MASTER_FILE_OBJID()
     * @uses RoomCategoryMasterFile::setCategory()
     * @uses RoomCategoryMasterFile::setMultiLangDescriptions()
     * @uses RoomCategoryMasterFile::setMultiLangComments()
     * @uses RoomCategoryMasterFile::setMultiLangComments2()
     * @param string $rOOM_CATEGORY_MASTER_FILE_OBJID
     * @param string $category
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @param \StructType\MultiLangComments[] $multiLangComments
     * @param \StructType\MultiLangComments2[] $multiLangComments2
     */
    public function __construct($rOOM_CATEGORY_MASTER_FILE_OBJID = null, $category = null, array $multiLangDescriptions = array(), array $multiLangComments = array(), array $multiLangComments2 = array())
    {
        $this
            ->setROOM_CATEGORY_MASTER_FILE_OBJID($rOOM_CATEGORY_MASTER_FILE_OBJID)
            ->setCategory($category)
            ->setMultiLangDescriptions($multiLangDescriptions)
            ->setMultiLangComments($multiLangComments)
            ->setMultiLangComments2($multiLangComments2);
    }
    /**
     * Get ROOM_CATEGORY_MASTER_FILE_OBJID value
     * @return string
     */
    public function getROOM_CATEGORY_MASTER_FILE_OBJID()
    {
        return $this->{'ROOM-CATEGORY-MASTER-FILE-OBJID'};
    }
    /**
     * Set ROOM_CATEGORY_MASTER_FILE_OBJID value
     * @param string $rOOM_CATEGORY_MASTER_FILE_OBJID
     * @return \StructType\RoomCategoryMasterFile
     */
    public function setROOM_CATEGORY_MASTER_FILE_OBJID($rOOM_CATEGORY_MASTER_FILE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_CATEGORY_MASTER_FILE_OBJID) && !is_string($rOOM_CATEGORY_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_CATEGORY_MASTER_FILE_OBJID, true), gettype($rOOM_CATEGORY_MASTER_FILE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_CATEGORY_MASTER_FILE_OBJID) && !preg_match('/([0-9])*/', $rOOM_CATEGORY_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_CATEGORY_MASTER_FILE_OBJID, true)), __LINE__);
        }
        $this->ROOM_CATEGORY_MASTER_FILE_OBJID = $this->{'ROOM-CATEGORY-MASTER-FILE-OBJID'} = $rOOM_CATEGORY_MASTER_FILE_OBJID;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\RoomCategoryMasterFile
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get MultiLangDescriptions value
     * @return \StructType\MultiLangDescriptions[]|null
     */
    public function getMultiLangDescriptions()
    {
        return $this->MultiLangDescriptions;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangDescriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangDescriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomCategoryMasterFileMultiLangDescriptionsItem) {
            // validation for constraint: itemType
            if (!$roomCategoryMasterFileMultiLangDescriptionsItem instanceof \StructType\MultiLangDescriptions) {
                $invalidValues[] = is_object($roomCategoryMasterFileMultiLangDescriptionsItem) ? get_class($roomCategoryMasterFileMultiLangDescriptionsItem) : sprintf('%s(%s)', gettype($roomCategoryMasterFileMultiLangDescriptionsItem), var_export($roomCategoryMasterFileMultiLangDescriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @return \StructType\RoomCategoryMasterFile
     */
    public function setMultiLangDescriptions(array $multiLangDescriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangDescriptionsArrayErrorMessage = self::validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions($multiLangDescriptions))) {
            throw new \InvalidArgumentException($multiLangDescriptionsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangDescriptions = $multiLangDescriptions;
        return $this;
    }
    /**
     * Add item to MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions $item
     * @return \StructType\RoomCategoryMasterFile
     */
    public function addToMultiLangDescriptions(\StructType\MultiLangDescriptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangDescriptions) {
            throw new \InvalidArgumentException(sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangDescriptions[] = $item;
        return $this;
    }
    /**
     * Get MultiLangComments value
     * @return \StructType\MultiLangComments[]|null
     */
    public function getMultiLangComments()
    {
        return $this->MultiLangComments;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangComments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangComments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomCategoryMasterFileMultiLangCommentsItem) {
            // validation for constraint: itemType
            if (!$roomCategoryMasterFileMultiLangCommentsItem instanceof \StructType\MultiLangComments) {
                $invalidValues[] = is_object($roomCategoryMasterFileMultiLangCommentsItem) ? get_class($roomCategoryMasterFileMultiLangCommentsItem) : sprintf('%s(%s)', gettype($roomCategoryMasterFileMultiLangCommentsItem), var_export($roomCategoryMasterFileMultiLangCommentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments[] $multiLangComments
     * @return \StructType\RoomCategoryMasterFile
     */
    public function setMultiLangComments(array $multiLangComments = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangCommentsArrayErrorMessage = self::validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments($multiLangComments))) {
            throw new \InvalidArgumentException($multiLangCommentsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangComments = $multiLangComments;
        return $this;
    }
    /**
     * Add item to MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments $item
     * @return \StructType\RoomCategoryMasterFile
     */
    public function addToMultiLangComments(\StructType\MultiLangComments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangComments) {
            throw new \InvalidArgumentException(sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangComments[] = $item;
        return $this;
    }
    /**
     * Get MultiLangComments2 value
     * @return \StructType\MultiLangComments2[]|null
     */
    public function getMultiLangComments2()
    {
        return $this->MultiLangComments2;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangComments2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangComments2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangComments2ForArrayConstraintsFromSetMultiLangComments2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomCategoryMasterFileMultiLangComments2Item) {
            // validation for constraint: itemType
            if (!$roomCategoryMasterFileMultiLangComments2Item instanceof \StructType\MultiLangComments2) {
                $invalidValues[] = is_object($roomCategoryMasterFileMultiLangComments2Item) ? get_class($roomCategoryMasterFileMultiLangComments2Item) : sprintf('%s(%s)', gettype($roomCategoryMasterFileMultiLangComments2Item), var_export($roomCategoryMasterFileMultiLangComments2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangComments2 property can only contain items of type \StructType\MultiLangComments2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangComments2 value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments2[] $multiLangComments2
     * @return \StructType\RoomCategoryMasterFile
     */
    public function setMultiLangComments2(array $multiLangComments2 = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangComments2ArrayErrorMessage = self::validateMultiLangComments2ForArrayConstraintsFromSetMultiLangComments2($multiLangComments2))) {
            throw new \InvalidArgumentException($multiLangComments2ArrayErrorMessage, __LINE__);
        }
        $this->MultiLangComments2 = $multiLangComments2;
        return $this;
    }
    /**
     * Add item to MultiLangComments2 value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments2 $item
     * @return \StructType\RoomCategoryMasterFile
     */
    public function addToMultiLangComments2(\StructType\MultiLangComments2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangComments2) {
            throw new \InvalidArgumentException(sprintf('The MultiLangComments2 property can only contain items of type \StructType\MultiLangComments2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangComments2[] = $item;
        return $this;
    }
}
