<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomCategory StructType
 * @subpackage Structs
 */
class RoomCategory extends AbstractStructBase
{
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $rate;
    /**
     * The minvacantrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $minvacantrooms;
    /**
     * The CategoryMasterFile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategoryMasterFile[]
     */
    public $CategoryMasterFile;
    /**
     * Constructor method for RoomCategory
     * @uses RoomCategory::setCategory()
     * @uses RoomCategory::setRate()
     * @uses RoomCategory::setMinvacantrooms()
     * @uses RoomCategory::setCategoryMasterFile()
     * @param string $category
     * @param string $rate
     * @param string $minvacantrooms
     * @param \StructType\CategoryMasterFile[] $categoryMasterFile
     */
    public function __construct($category = null, $rate = null, $minvacantrooms = null, array $categoryMasterFile = array())
    {
        $this
            ->setCategory($category)
            ->setRate($rate)
            ->setMinvacantrooms($minvacantrooms)
            ->setCategoryMasterFile($categoryMasterFile);
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\RoomCategory
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get rate value
     * @return string
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\RoomCategory
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($rate) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($rate, true)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get minvacantrooms value
     * @return string
     */
    public function getMinvacantrooms()
    {
        return $this->minvacantrooms;
    }
    /**
     * Set minvacantrooms value
     * @param string $minvacantrooms
     * @return \StructType\RoomCategory
     */
    public function setMinvacantrooms($minvacantrooms = null)
    {
        // validation for constraint: string
        if (!is_null($minvacantrooms) && !is_string($minvacantrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minvacantrooms, true), gettype($minvacantrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($minvacantrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $minvacantrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($minvacantrooms, true)), __LINE__);
        }
        $this->minvacantrooms = $minvacantrooms;
        return $this;
    }
    /**
     * Get CategoryMasterFile value
     * @return \StructType\CategoryMasterFile[]|null
     */
    public function getCategoryMasterFile()
    {
        return $this->CategoryMasterFile;
    }
    /**
     * This method is responsible for validating the values passed to the setCategoryMasterFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategoryMasterFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryMasterFileForArrayConstraintsFromSetCategoryMasterFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomCategoryCategoryMasterFileItem) {
            // validation for constraint: itemType
            if (!$roomCategoryCategoryMasterFileItem instanceof \StructType\CategoryMasterFile) {
                $invalidValues[] = is_object($roomCategoryCategoryMasterFileItem) ? get_class($roomCategoryCategoryMasterFileItem) : sprintf('%s(%s)', gettype($roomCategoryCategoryMasterFileItem), var_export($roomCategoryCategoryMasterFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CategoryMasterFile property can only contain items of type \StructType\CategoryMasterFile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CategoryMasterFile value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryMasterFile[] $categoryMasterFile
     * @return \StructType\RoomCategory
     */
    public function setCategoryMasterFile(array $categoryMasterFile = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryMasterFileArrayErrorMessage = self::validateCategoryMasterFileForArrayConstraintsFromSetCategoryMasterFile($categoryMasterFile))) {
            throw new \InvalidArgumentException($categoryMasterFileArrayErrorMessage, __LINE__);
        }
        $this->CategoryMasterFile = $categoryMasterFile;
        return $this;
    }
    /**
     * Add item to CategoryMasterFile value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryMasterFile $item
     * @return \StructType\RoomCategory
     */
    public function addToCategoryMasterFile(\StructType\CategoryMasterFile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryMasterFile) {
            throw new \InvalidArgumentException(sprintf('The CategoryMasterFile property can only contain items of type \StructType\CategoryMasterFile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CategoryMasterFile[] = $item;
        return $this;
    }
}
