<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reservation StructType
 * @subpackage Structs
 */
class Reservation_2 extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The GUEST_PAYMENT_INSTRUCTION_GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_PAYMENT_INSTRUCTION_GUEST_OBJID;
    /**
     * The CLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $CLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID;
    /**
     * The GROUP_PAYMENT_INSTRUCTION_GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GROUP_PAYMENT_INSTRUCTION_GUEST_OBJID;
    /**
     * The RESERVATION_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_CENTRALID;
    /**
     * Constructor method for reservation
     * @uses Reservation_2::setRESERVATION_OBJID()
     * @uses Reservation_2::setGUEST_PAYMENT_INSTRUCTION_GUEST_OBJID()
     * @uses Reservation_2::setCLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID()
     * @uses Reservation_2::setGROUP_PAYMENT_INSTRUCTION_GUEST_OBJID()
     * @uses Reservation_2::setRESERVATION_CENTRALID()
     * @param string $rESERVATION_OBJID
     * @param string $gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID
     * @param string $cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID
     * @param string $gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID
     * @param string $rESERVATION_CENTRALID
     */
    public function __construct($rESERVATION_OBJID = null, $gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID = null, $cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID = null, $gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID = null, $rESERVATION_CENTRALID = null)
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setGUEST_PAYMENT_INSTRUCTION_GUEST_OBJID($gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID)
            ->setCLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID($cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID)
            ->setGROUP_PAYMENT_INSTRUCTION_GUEST_OBJID($gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID)
            ->setRESERVATION_CENTRALID($rESERVATION_CENTRALID);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\Reservation_2
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get GUEST_PAYMENT_INSTRUCTION_GUEST_OBJID value
     * @return string
     */
    public function getGUEST_PAYMENT_INSTRUCTION_GUEST_OBJID()
    {
        return $this->{'GUEST-PAYMENT-INSTRUCTION-GUEST-OBJID'};
    }
    /**
     * Set GUEST_PAYMENT_INSTRUCTION_GUEST_OBJID value
     * @param string $gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID
     * @return \StructType\Reservation_2
     */
    public function setGUEST_PAYMENT_INSTRUCTION_GUEST_OBJID($gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID) && !is_string($gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID, true), gettype($gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_PAYMENT_INSTRUCTION_GUEST_OBJID = $this->{'GUEST-PAYMENT-INSTRUCTION-GUEST-OBJID'} = $gUEST_PAYMENT_INSTRUCTION_GUEST_OBJID;
        return $this;
    }
    /**
     * Get CLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID value
     * @return string
     */
    public function getCLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID()
    {
        return $this->{'CLIENT-PAYMENT-INSTRUCTION-GUEST-OBJID'};
    }
    /**
     * Set CLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID value
     * @param string $cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID
     * @return \StructType\Reservation_2
     */
    public function setCLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID($cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID) && !is_string($cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID, true), gettype($cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID) && !preg_match('/([0-9])*/', $cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID, true)), __LINE__);
        }
        $this->CLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID = $this->{'CLIENT-PAYMENT-INSTRUCTION-GUEST-OBJID'} = $cLIENT_PAYMENT_INSTRUCTION_GUEST_OBJID;
        return $this;
    }
    /**
     * Get GROUP_PAYMENT_INSTRUCTION_GUEST_OBJID value
     * @return string
     */
    public function getGROUP_PAYMENT_INSTRUCTION_GUEST_OBJID()
    {
        return $this->{'GROUP-PAYMENT-INSTRUCTION-GUEST-OBJID'};
    }
    /**
     * Set GROUP_PAYMENT_INSTRUCTION_GUEST_OBJID value
     * @param string $gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID
     * @return \StructType\Reservation_2
     */
    public function setGROUP_PAYMENT_INSTRUCTION_GUEST_OBJID($gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID) && !is_string($gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID, true), gettype($gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID) && !preg_match('/([0-9])*/', $gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID, true)), __LINE__);
        }
        $this->GROUP_PAYMENT_INSTRUCTION_GUEST_OBJID = $this->{'GROUP-PAYMENT-INSTRUCTION-GUEST-OBJID'} = $gROUP_PAYMENT_INSTRUCTION_GUEST_OBJID;
        return $this;
    }
    /**
     * Get RESERVATION_CENTRALID value
     * @return string|null
     */
    public function getRESERVATION_CENTRALID()
    {
        return $this->{'RESERVATION-CENTRALID'};
    }
    /**
     * Set RESERVATION_CENTRALID value
     * @param string $rESERVATION_CENTRALID
     * @return \StructType\Reservation_2
     */
    public function setRESERVATION_CENTRALID($rESERVATION_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_CENTRALID) && !is_string($rESERVATION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_CENTRALID, true), gettype($rESERVATION_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_CENTRALID) && !preg_match('/([0-9])*/', $rESERVATION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_CENTRALID, true)), __LINE__);
        }
        $this->RESERVATION_CENTRALID = $this->{'RESERVATION-CENTRALID'} = $rESERVATION_CENTRALID;
        return $this;
    }
}
