<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationSearch StructType
 * @subpackage Structs
 */
class ReservationSearch extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The Reservation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Reservation_1
     */
    public $Reservation;
    /**
     * The kiosksearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kiosksearch;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name1;
    /**
     * The resnofrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resnofrom;
    /**
     * The resnoto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resnoto;
    /**
     * The gdsresnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gdsresnumber;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The findpersons
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $findpersons;
    /**
     * Constructor method for ReservationSearch
     * @uses ReservationSearch::setRESERVATION_OBJID()
     * @uses ReservationSearch::setReservation()
     * @uses ReservationSearch::setKiosksearch()
     * @uses ReservationSearch::setName1()
     * @uses ReservationSearch::setResnofrom()
     * @uses ReservationSearch::setResnoto()
     * @uses ReservationSearch::setGdsresnumber()
     * @uses ReservationSearch::setArrival()
     * @uses ReservationSearch::setDeparture()
     * @uses ReservationSearch::setFindpersons()
     * @param string $rESERVATION_OBJID
     * @param \StructType\Reservation_1 $reservation
     * @param string $kiosksearch
     * @param string $name1
     * @param string $resnofrom
     * @param string $resnoto
     * @param string $gdsresnumber
     * @param string $arrival
     * @param string $departure
     * @param string $findpersons
     */
    public function __construct($rESERVATION_OBJID = null, \StructType\Reservation_1 $reservation = null, $kiosksearch = null, $name1 = null, $resnofrom = null, $resnoto = null, $gdsresnumber = null, $arrival = null, $departure = null, $findpersons = null)
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setReservation($reservation)
            ->setKiosksearch($kiosksearch)
            ->setName1($name1)
            ->setResnofrom($resnofrom)
            ->setResnoto($resnoto)
            ->setGdsresnumber($gdsresnumber)
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setFindpersons($findpersons);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\ReservationSearch
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get Reservation value
     * @return \StructType\Reservation_1
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * Set Reservation value
     * @param \StructType\Reservation_1 $reservation
     * @return \StructType\ReservationSearch
     */
    public function setReservation(\StructType\Reservation_1 $reservation = null)
    {
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Get kiosksearch value
     * @return string|null
     */
    public function getKiosksearch()
    {
        return $this->kiosksearch;
    }
    /**
     * Set kiosksearch value
     * @param string $kiosksearch
     * @return \StructType\ReservationSearch
     */
    public function setKiosksearch($kiosksearch = null)
    {
        // validation for constraint: string
        if (!is_null($kiosksearch) && !is_string($kiosksearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kiosksearch, true), gettype($kiosksearch)), __LINE__);
        }
        $this->kiosksearch = $kiosksearch;
        return $this;
    }
    /**
     * Get name1 value
     * @return string|null
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\ReservationSearch
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get resnofrom value
     * @return string|null
     */
    public function getResnofrom()
    {
        return $this->resnofrom;
    }
    /**
     * Set resnofrom value
     * @param string $resnofrom
     * @return \StructType\ReservationSearch
     */
    public function setResnofrom($resnofrom = null)
    {
        // validation for constraint: string
        if (!is_null($resnofrom) && !is_string($resnofrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resnofrom, true), gettype($resnofrom)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resnofrom) && !preg_match('/([-+]){0,1}([0-9])*/', $resnofrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resnofrom, true)), __LINE__);
        }
        $this->resnofrom = $resnofrom;
        return $this;
    }
    /**
     * Get resnoto value
     * @return string|null
     */
    public function getResnoto()
    {
        return $this->resnoto;
    }
    /**
     * Set resnoto value
     * @param string $resnoto
     * @return \StructType\ReservationSearch
     */
    public function setResnoto($resnoto = null)
    {
        // validation for constraint: string
        if (!is_null($resnoto) && !is_string($resnoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resnoto, true), gettype($resnoto)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resnoto) && !preg_match('/([-+]){0,1}([0-9])*/', $resnoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resnoto, true)), __LINE__);
        }
        $this->resnoto = $resnoto;
        return $this;
    }
    /**
     * Get gdsresnumber value
     * @return string|null
     */
    public function getGdsresnumber()
    {
        return $this->gdsresnumber;
    }
    /**
     * Set gdsresnumber value
     * @param string $gdsresnumber
     * @return \StructType\ReservationSearch
     */
    public function setGdsresnumber($gdsresnumber = null)
    {
        // validation for constraint: string
        if (!is_null($gdsresnumber) && !is_string($gdsresnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gdsresnumber, true), gettype($gdsresnumber)), __LINE__);
        }
        $this->gdsresnumber = $gdsresnumber;
        return $this;
    }
    /**
     * Get arrival value
     * @return string|null
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\ReservationSearch
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string|null
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\ReservationSearch
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get findpersons value
     * @return string|null
     */
    public function getFindpersons()
    {
        return $this->findpersons;
    }
    /**
     * Set findpersons value
     * @param string $findpersons
     * @return \StructType\ReservationSearch
     */
    public function setFindpersons($findpersons = null)
    {
        // validation for constraint: string
        if (!is_null($findpersons) && !is_string($findpersons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($findpersons, true), gettype($findpersons)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($findpersons) && !preg_match('/([-+]){0,1}([0-9])*/', $findpersons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($findpersons, true)), __LINE__);
        }
        $this->findpersons = $findpersons;
        return $this;
    }
}
