<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResNewGroupReservationDummy StructType
 * @subpackage Structs
 */
class ResNewGroupReservationDummy extends AbstractStructBase
{
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The restype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $restype;
    /**
     * The noofrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofrooms;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $marketsegment;
    /**
     * The paymentinstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentinstructions;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $packages;
    /**
     * The commentadditional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commentadditional;
    /**
     * The guesttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $guesttype;
    /**
     * Constructor method for ResNewGroupReservationDummy
     * @uses ResNewGroupReservationDummy::setArrival()
     * @uses ResNewGroupReservationDummy::setDeparture()
     * @uses ResNewGroupReservationDummy::setCategory()
     * @uses ResNewGroupReservationDummy::setRatecategory()
     * @uses ResNewGroupReservationDummy::setRestype()
     * @uses ResNewGroupReservationDummy::setNoofrooms()
     * @uses ResNewGroupReservationDummy::setNoofpax()
     * @uses ResNewGroupReservationDummy::setMarketsegment()
     * @uses ResNewGroupReservationDummy::setPaymentinstructions()
     * @uses ResNewGroupReservationDummy::setPackages()
     * @uses ResNewGroupReservationDummy::setCommentadditional()
     * @uses ResNewGroupReservationDummy::setGuesttype()
     * @param string $arrival
     * @param string $departure
     * @param string $category
     * @param string $ratecategory
     * @param string $restype
     * @param string $noofrooms
     * @param string $noofpax
     * @param string $marketsegment
     * @param string $paymentinstructions
     * @param string $packages
     * @param string $commentadditional
     * @param string $guesttype
     */
    public function __construct($arrival = null, $departure = null, $category = null, $ratecategory = null, $restype = null, $noofrooms = null, $noofpax = null, $marketsegment = null, $paymentinstructions = null, $packages = null, $commentadditional = null, $guesttype = null)
    {
        $this
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setCategory($category)
            ->setRatecategory($ratecategory)
            ->setRestype($restype)
            ->setNoofrooms($noofrooms)
            ->setNoofpax($noofpax)
            ->setMarketsegment($marketsegment)
            ->setPaymentinstructions($paymentinstructions)
            ->setPackages($packages)
            ->setCommentadditional($commentadditional)
            ->setGuesttype($guesttype);
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ratecategory) && mb_strlen($ratecategory) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($ratecategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratecategory) && mb_strlen($ratecategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get restype value
     * @return string
     */
    public function getRestype()
    {
        return $this->restype;
    }
    /**
     * Set restype value
     * @param string $restype
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setRestype($restype = null)
    {
        // validation for constraint: string
        if (!is_null($restype) && !is_string($restype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restype, true), gettype($restype)), __LINE__);
        }
        $this->restype = $restype;
        return $this;
    }
    /**
     * Get noofrooms value
     * @return string
     */
    public function getNoofrooms()
    {
        return $this->noofrooms;
    }
    /**
     * Set noofrooms value
     * @param string $noofrooms
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setNoofrooms($noofrooms = null)
    {
        // validation for constraint: string
        if (!is_null($noofrooms) && !is_string($noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofrooms, true), gettype($noofrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofrooms, true)), __LINE__);
        }
        $this->noofrooms = $noofrooms;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($marketsegment) && mb_strlen($marketsegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($marketsegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($marketsegment) && mb_strlen($marketsegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get paymentinstructions value
     * @return string
     */
    public function getPaymentinstructions()
    {
        return $this->paymentinstructions;
    }
    /**
     * Set paymentinstructions value
     * @param string $paymentinstructions
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setPaymentinstructions($paymentinstructions = null)
    {
        // validation for constraint: string
        if (!is_null($paymentinstructions) && !is_string($paymentinstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentinstructions, true), gettype($paymentinstructions)), __LINE__);
        }
        $this->paymentinstructions = $paymentinstructions;
        return $this;
    }
    /**
     * Get packages value
     * @return string
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * Set packages value
     * @param string $packages
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setPackages($packages = null)
    {
        // validation for constraint: string
        if (!is_null($packages) && !is_string($packages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packages, true), gettype($packages)), __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
    /**
     * Get commentadditional value
     * @return string|null
     */
    public function getCommentadditional()
    {
        return $this->commentadditional;
    }
    /**
     * Set commentadditional value
     * @param string $commentadditional
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setCommentadditional($commentadditional = null)
    {
        // validation for constraint: string
        if (!is_null($commentadditional) && !is_string($commentadditional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentadditional, true), gettype($commentadditional)), __LINE__);
        }
        $this->commentadditional = $commentadditional;
        return $this;
    }
    /**
     * Get guesttype value
     * @return string|null
     */
    public function getGuesttype()
    {
        return $this->guesttype;
    }
    /**
     * Set guesttype value
     * @param string $guesttype
     * @return \StructType\ResNewGroupReservationDummy
     */
    public function setGuesttype($guesttype = null)
    {
        // validation for constraint: string
        if (!is_null($guesttype) && !is_string($guesttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guesttype, true), gettype($guesttype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($guesttype) && mb_strlen($guesttype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($guesttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guesttype) && mb_strlen($guesttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guesttype)), __LINE__);
        }
        $this->guesttype = $guesttype;
        return $this;
    }
}
