<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistrationCardSearch StructType
 * @subpackage Structs
 */
class RegistrationCardSearch extends AbstractStructBase
{
    /**
     * The REGISTRATIONCARD_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $REGISTRATIONCARD_OBJID;
    /**
     * Constructor method for RegistrationCardSearch
     * @uses RegistrationCardSearch::setREGISTRATIONCARD_OBJID()
     * @param string $rEGISTRATIONCARD_OBJID
     */
    public function __construct($rEGISTRATIONCARD_OBJID = null)
    {
        $this
            ->setREGISTRATIONCARD_OBJID($rEGISTRATIONCARD_OBJID);
    }
    /**
     * Get REGISTRATIONCARD_OBJID value
     * @return string
     */
    public function getREGISTRATIONCARD_OBJID()
    {
        return $this->{'REGISTRATIONCARD-OBJID'};
    }
    /**
     * Set REGISTRATIONCARD_OBJID value
     * @param string $rEGISTRATIONCARD_OBJID
     * @return \StructType\RegistrationCardSearch
     */
    public function setREGISTRATIONCARD_OBJID($rEGISTRATIONCARD_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rEGISTRATIONCARD_OBJID) && !is_string($rEGISTRATIONCARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEGISTRATIONCARD_OBJID, true), gettype($rEGISTRATIONCARD_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rEGISTRATIONCARD_OBJID) && !preg_match('/([0-9])*/', $rEGISTRATIONCARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rEGISTRATIONCARD_OBJID, true)), __LINE__);
        }
        $this->REGISTRATIONCARD_OBJID = $this->{'REGISTRATIONCARD-OBJID'} = $rEGISTRATIONCARD_OBJID;
        return $this;
    }
}
