<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecentCreated StructType
 * @subpackage Structs
 */
class RecentCreated extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The subno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $subno;
    /**
     * The restype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $restype;
    /**
     * Constructor method for RecentCreated
     * @uses RecentCreated::setRESERVATION_OBJID()
     * @uses RecentCreated::setHotel()
     * @uses RecentCreated::setResno()
     * @uses RecentCreated::setSubno()
     * @uses RecentCreated::setRestype()
     * @param string $rESERVATION_OBJID
     * @param string $hotel
     * @param string $resno
     * @param string $subno
     * @param string $restype
     */
    public function __construct($rESERVATION_OBJID = null, $hotel = null, $resno = null, $subno = null, $restype = null)
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setHotel($hotel)
            ->setResno($resno)
            ->setSubno($subno)
            ->setRestype($restype);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\RecentCreated
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\RecentCreated
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\RecentCreated
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get subno value
     * @return string
     */
    public function getSubno()
    {
        return $this->subno;
    }
    /**
     * Set subno value
     * @param string $subno
     * @return \StructType\RecentCreated
     */
    public function setSubno($subno = null)
    {
        // validation for constraint: string
        if (!is_null($subno) && !is_string($subno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subno, true), gettype($subno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($subno) && !preg_match('/([-+]){0,1}([0-9])*/', $subno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($subno, true)), __LINE__);
        }
        $this->subno = $subno;
        return $this;
    }
    /**
     * Get restype value
     * @return string
     */
    public function getRestype()
    {
        return $this->restype;
    }
    /**
     * Set restype value
     * @param string $restype
     * @return \StructType\RecentCreated
     */
    public function setRestype($restype = null)
    {
        // validation for constraint: string
        if (!is_null($restype) && !is_string($restype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restype, true), gettype($restype)), __LINE__);
        }
        $this->restype = $restype;
        return $this;
    }
}
