<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ROOM StructType
 * @subpackage Structs
 */
class ROOM_2 extends AbstractStructBase
{
    /**
     * The ROOM_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_OBJID;
    /**
     * The floor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $floor;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The roomlocation
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $roomlocation;
    /**
     * The housekeeping
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $housekeeping;
    /**
     * The PERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PERSON_OBJID;
    /**
     * The ROOMINGLIST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMINGLIST_OBJID;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The noofchildren
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofchildren;
    /**
     * The noofadults
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofadults;
    /**
     * The noofnights
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofnights;
    /**
     * The ROOM_NUMBER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ROOM_NUMBER;
    /**
     * The forecastnoofadults
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofadults;
    /**
     * The forecastnoofchildren
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofchildren;
    /**
     * The forecastnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $forecastnoofpax;
    /**
     * The forecastrategross
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastrategross;
    /**
     * The forecastratenet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastratenet;
    /**
     * The forecastlogisgross
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastlogisgross;
    /**
     * The forecastlogisnet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastlogisnet;
    /**
     * The hasautoservice
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hasautoservice;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The persontype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $persontype;
    /**
     * The PERSON
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PERSON_2[]
     */
    public $PERSON;
    /**
     * Constructor method for ROOM
     * @uses ROOM_2::setROOM_OBJID()
     * @uses ROOM_2::setFloor()
     * @uses ROOM_2::setRoom()
     * @uses ROOM_2::setRoomlocation()
     * @uses ROOM_2::setHousekeeping()
     * @uses ROOM_2::setPERSON_OBJID()
     * @uses ROOM_2::setROOMINGLIST_OBJID()
     * @uses ROOM_2::setCategory()
     * @uses ROOM_2::setDatefrom()
     * @uses ROOM_2::setDateto()
     * @uses ROOM_2::setNoofpax()
     * @uses ROOM_2::setNoofchildren()
     * @uses ROOM_2::setNoofadults()
     * @uses ROOM_2::setNoofnights()
     * @uses ROOM_2::setROOM_NUMBER()
     * @uses ROOM_2::setForecastnoofadults()
     * @uses ROOM_2::setForecastnoofchildren()
     * @uses ROOM_2::setForecastnoofpax()
     * @uses ROOM_2::setForecastrategross()
     * @uses ROOM_2::setForecastratenet()
     * @uses ROOM_2::setForecastlogisgross()
     * @uses ROOM_2::setForecastlogisnet()
     * @uses ROOM_2::setHasautoservice()
     * @uses ROOM_2::setCurrency()
     * @uses ROOM_2::setRatecategory()
     * @uses ROOM_2::setRatesegment()
     * @uses ROOM_2::setPersontype()
     * @uses ROOM_2::setPERSON()
     * @param string $rOOM_OBJID
     * @param string $floor
     * @param string $room
     * @param string $roomlocation
     * @param string $housekeeping
     * @param string $pERSON_OBJID
     * @param string $rOOMINGLIST_OBJID
     * @param string $category
     * @param string $datefrom
     * @param string $dateto
     * @param string $noofpax
     * @param string $noofchildren
     * @param string $noofadults
     * @param string $noofnights
     * @param string $rOOM_NUMBER
     * @param string $forecastnoofadults
     * @param string $forecastnoofchildren
     * @param string $forecastnoofpax
     * @param string $forecastrategross
     * @param string $forecastratenet
     * @param string $forecastlogisgross
     * @param string $forecastlogisnet
     * @param string $hasautoservice
     * @param string $currency
     * @param string $ratecategory
     * @param string $ratesegment
     * @param string $persontype
     * @param \StructType\PERSON_2[] $pERSON
     */
    public function __construct($rOOM_OBJID = null, $floor = null, $room = null, $roomlocation = null, $housekeeping = null, $pERSON_OBJID = null, $rOOMINGLIST_OBJID = null, $category = null, $datefrom = null, $dateto = null, $noofpax = null, $noofchildren = null, $noofadults = null, $noofnights = null, $rOOM_NUMBER = null, $forecastnoofadults = null, $forecastnoofchildren = null, $forecastnoofpax = null, $forecastrategross = null, $forecastratenet = null, $forecastlogisgross = null, $forecastlogisnet = null, $hasautoservice = null, $currency = null, $ratecategory = null, $ratesegment = null, $persontype = null, array $pERSON = array())
    {
        $this
            ->setROOM_OBJID($rOOM_OBJID)
            ->setFloor($floor)
            ->setRoom($room)
            ->setRoomlocation($roomlocation)
            ->setHousekeeping($housekeeping)
            ->setPERSON_OBJID($pERSON_OBJID)
            ->setROOMINGLIST_OBJID($rOOMINGLIST_OBJID)
            ->setCategory($category)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setNoofpax($noofpax)
            ->setNoofchildren($noofchildren)
            ->setNoofadults($noofadults)
            ->setNoofnights($noofnights)
            ->setROOM_NUMBER($rOOM_NUMBER)
            ->setForecastnoofadults($forecastnoofadults)
            ->setForecastnoofchildren($forecastnoofchildren)
            ->setForecastnoofpax($forecastnoofpax)
            ->setForecastrategross($forecastrategross)
            ->setForecastratenet($forecastratenet)
            ->setForecastlogisgross($forecastlogisgross)
            ->setForecastlogisnet($forecastlogisnet)
            ->setHasautoservice($hasautoservice)
            ->setCurrency($currency)
            ->setRatecategory($ratecategory)
            ->setRatesegment($ratesegment)
            ->setPersontype($persontype)
            ->setPERSON($pERSON);
    }
    /**
     * Get ROOM_OBJID value
     * @return string
     */
    public function getROOM_OBJID()
    {
        return $this->{'ROOM-OBJID'};
    }
    /**
     * Set ROOM_OBJID value
     * @param string $rOOM_OBJID
     * @return \StructType\ROOM_2
     */
    public function setROOM_OBJID($rOOM_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_OBJID) && !is_string($rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_OBJID, true), gettype($rOOM_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_OBJID) && !preg_match('/([0-9])*/', $rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_OBJID, true)), __LINE__);
        }
        $this->ROOM_OBJID = $this->{'ROOM-OBJID'} = $rOOM_OBJID;
        return $this;
    }
    /**
     * Get floor value
     * @return string
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \StructType\ROOM_2
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($floor) && mb_strlen($floor) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($floor)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($floor) && mb_strlen($floor) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\ROOM_2
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get roomlocation value
     * @return string
     */
    public function getRoomlocation()
    {
        return $this->roomlocation;
    }
    /**
     * Set roomlocation value
     * @param string $roomlocation
     * @return \StructType\ROOM_2
     */
    public function setRoomlocation($roomlocation = null)
    {
        // validation for constraint: string
        if (!is_null($roomlocation) && !is_string($roomlocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomlocation, true), gettype($roomlocation)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($roomlocation) && mb_strlen($roomlocation) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($roomlocation)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($roomlocation) && mb_strlen($roomlocation) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($roomlocation)), __LINE__);
        }
        $this->roomlocation = $roomlocation;
        return $this;
    }
    /**
     * Get housekeeping value
     * @return string
     */
    public function getHousekeeping()
    {
        return $this->housekeeping;
    }
    /**
     * Set housekeeping value
     * @param string $housekeeping
     * @return \StructType\ROOM_2
     */
    public function setHousekeeping($housekeeping = null)
    {
        // validation for constraint: string
        if (!is_null($housekeeping) && !is_string($housekeeping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeeping, true), gettype($housekeeping)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($housekeeping) && mb_strlen($housekeeping) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($housekeeping)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($housekeeping) && mb_strlen($housekeeping) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($housekeeping)), __LINE__);
        }
        $this->housekeeping = $housekeeping;
        return $this;
    }
    /**
     * Get PERSON_OBJID value
     * @return string
     */
    public function getPERSON_OBJID()
    {
        return $this->{'PERSON-OBJID'};
    }
    /**
     * Set PERSON_OBJID value
     * @param string $pERSON_OBJID
     * @return \StructType\ROOM_2
     */
    public function setPERSON_OBJID($pERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pERSON_OBJID) && !is_string($pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pERSON_OBJID, true), gettype($pERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pERSON_OBJID) && !preg_match('/([0-9])*/', $pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pERSON_OBJID, true)), __LINE__);
        }
        $this->PERSON_OBJID = $this->{'PERSON-OBJID'} = $pERSON_OBJID;
        return $this;
    }
    /**
     * Get ROOMINGLIST_OBJID value
     * @return string
     */
    public function getROOMINGLIST_OBJID()
    {
        return $this->{'ROOMINGLIST-OBJID'};
    }
    /**
     * Set ROOMINGLIST_OBJID value
     * @param string $rOOMINGLIST_OBJID
     * @return \StructType\ROOM_2
     */
    public function setROOMINGLIST_OBJID($rOOMINGLIST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMINGLIST_OBJID) && !is_string($rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMINGLIST_OBJID, true), gettype($rOOMINGLIST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMINGLIST_OBJID) && !preg_match('/([0-9])*/', $rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMINGLIST_OBJID, true)), __LINE__);
        }
        $this->ROOMINGLIST_OBJID = $this->{'ROOMINGLIST-OBJID'} = $rOOMINGLIST_OBJID;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ROOM_2
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\ROOM_2
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\ROOM_2
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\ROOM_2
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get noofchildren value
     * @return string
     */
    public function getNoofchildren()
    {
        return $this->noofchildren;
    }
    /**
     * Set noofchildren value
     * @param string $noofchildren
     * @return \StructType\ROOM_2
     */
    public function setNoofchildren($noofchildren = null)
    {
        // validation for constraint: string
        if (!is_null($noofchildren) && !is_string($noofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofchildren, true), gettype($noofchildren)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofchildren) && !preg_match('/([-+]){0,1}([0-9])*/', $noofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofchildren, true)), __LINE__);
        }
        $this->noofchildren = $noofchildren;
        return $this;
    }
    /**
     * Get noofadults value
     * @return string
     */
    public function getNoofadults()
    {
        return $this->noofadults;
    }
    /**
     * Set noofadults value
     * @param string $noofadults
     * @return \StructType\ROOM_2
     */
    public function setNoofadults($noofadults = null)
    {
        // validation for constraint: string
        if (!is_null($noofadults) && !is_string($noofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofadults, true), gettype($noofadults)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofadults) && !preg_match('/([-+]){0,1}([0-9])*/', $noofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofadults, true)), __LINE__);
        }
        $this->noofadults = $noofadults;
        return $this;
    }
    /**
     * Get noofnights value
     * @return string
     */
    public function getNoofnights()
    {
        return $this->noofnights;
    }
    /**
     * Set noofnights value
     * @param string $noofnights
     * @return \StructType\ROOM_2
     */
    public function setNoofnights($noofnights = null)
    {
        // validation for constraint: string
        if (!is_null($noofnights) && !is_string($noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofnights, true), gettype($noofnights)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofnights) && !preg_match('/([-+]){0,1}([0-9])*/', $noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofnights, true)), __LINE__);
        }
        $this->noofnights = $noofnights;
        return $this;
    }
    /**
     * Get ROOM_NUMBER value
     * @return string
     */
    public function getROOM_NUMBER()
    {
        return $this->{'ROOM-NUMBER'};
    }
    /**
     * Set ROOM_NUMBER value
     * @param string $rOOM_NUMBER
     * @return \StructType\ROOM_2
     */
    public function setROOM_NUMBER($rOOM_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_NUMBER) && !is_string($rOOM_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_NUMBER, true), gettype($rOOM_NUMBER)), __LINE__);
        }
        $this->ROOM_NUMBER = $this->{'ROOM-NUMBER'} = $rOOM_NUMBER;
        return $this;
    }
    /**
     * Get forecastnoofadults value
     * @return string
     */
    public function getForecastnoofadults()
    {
        return $this->forecastnoofadults;
    }
    /**
     * Set forecastnoofadults value
     * @param string $forecastnoofadults
     * @return \StructType\ROOM_2
     */
    public function setForecastnoofadults($forecastnoofadults = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofadults) && !is_string($forecastnoofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofadults, true), gettype($forecastnoofadults)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofadults) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofadults, true)), __LINE__);
        }
        $this->forecastnoofadults = $forecastnoofadults;
        return $this;
    }
    /**
     * Get forecastnoofchildren value
     * @return string
     */
    public function getForecastnoofchildren()
    {
        return $this->forecastnoofchildren;
    }
    /**
     * Set forecastnoofchildren value
     * @param string $forecastnoofchildren
     * @return \StructType\ROOM_2
     */
    public function setForecastnoofchildren($forecastnoofchildren = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofchildren) && !is_string($forecastnoofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofchildren, true), gettype($forecastnoofchildren)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofchildren) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofchildren, true)), __LINE__);
        }
        $this->forecastnoofchildren = $forecastnoofchildren;
        return $this;
    }
    /**
     * Get forecastnoofpax value
     * @return string
     */
    public function getForecastnoofpax()
    {
        return $this->forecastnoofpax;
    }
    /**
     * Set forecastnoofpax value
     * @param string $forecastnoofpax
     * @return \StructType\ROOM_2
     */
    public function setForecastnoofpax($forecastnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($forecastnoofpax) && !is_string($forecastnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastnoofpax, true), gettype($forecastnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($forecastnoofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $forecastnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($forecastnoofpax, true)), __LINE__);
        }
        $this->forecastnoofpax = $forecastnoofpax;
        return $this;
    }
    /**
     * Get forecastrategross value
     * @return string
     */
    public function getForecastrategross()
    {
        return $this->forecastrategross;
    }
    /**
     * Set forecastrategross value
     * @param string $forecastrategross
     * @return \StructType\ROOM_2
     */
    public function setForecastrategross($forecastrategross = null)
    {
        // validation for constraint: string
        if (!is_null($forecastrategross) && !is_string($forecastrategross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastrategross, true), gettype($forecastrategross)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastrategross) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastrategross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastrategross, true)), __LINE__);
        }
        $this->forecastrategross = $forecastrategross;
        return $this;
    }
    /**
     * Get forecastratenet value
     * @return string
     */
    public function getForecastratenet()
    {
        return $this->forecastratenet;
    }
    /**
     * Set forecastratenet value
     * @param string $forecastratenet
     * @return \StructType\ROOM_2
     */
    public function setForecastratenet($forecastratenet = null)
    {
        // validation for constraint: string
        if (!is_null($forecastratenet) && !is_string($forecastratenet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastratenet, true), gettype($forecastratenet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastratenet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastratenet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastratenet, true)), __LINE__);
        }
        $this->forecastratenet = $forecastratenet;
        return $this;
    }
    /**
     * Get forecastlogisgross value
     * @return string
     */
    public function getForecastlogisgross()
    {
        return $this->forecastlogisgross;
    }
    /**
     * Set forecastlogisgross value
     * @param string $forecastlogisgross
     * @return \StructType\ROOM_2
     */
    public function setForecastlogisgross($forecastlogisgross = null)
    {
        // validation for constraint: string
        if (!is_null($forecastlogisgross) && !is_string($forecastlogisgross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastlogisgross, true), gettype($forecastlogisgross)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastlogisgross) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastlogisgross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastlogisgross, true)), __LINE__);
        }
        $this->forecastlogisgross = $forecastlogisgross;
        return $this;
    }
    /**
     * Get forecastlogisnet value
     * @return string
     */
    public function getForecastlogisnet()
    {
        return $this->forecastlogisnet;
    }
    /**
     * Set forecastlogisnet value
     * @param string $forecastlogisnet
     * @return \StructType\ROOM_2
     */
    public function setForecastlogisnet($forecastlogisnet = null)
    {
        // validation for constraint: string
        if (!is_null($forecastlogisnet) && !is_string($forecastlogisnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastlogisnet, true), gettype($forecastlogisnet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastlogisnet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastlogisnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastlogisnet, true)), __LINE__);
        }
        $this->forecastlogisnet = $forecastlogisnet;
        return $this;
    }
    /**
     * Get hasautoservice value
     * @return string
     */
    public function getHasautoservice()
    {
        return $this->hasautoservice;
    }
    /**
     * Set hasautoservice value
     * @param string $hasautoservice
     * @return \StructType\ROOM_2
     */
    public function setHasautoservice($hasautoservice = null)
    {
        // validation for constraint: string
        if (!is_null($hasautoservice) && !is_string($hasautoservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hasautoservice, true), gettype($hasautoservice)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hasautoservice) && !preg_match('/([-+]){0,1}([0-9])*/', $hasautoservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hasautoservice, true)), __LINE__);
        }
        $this->hasautoservice = $hasautoservice;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ROOM_2
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\ROOM_2
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ratecategory) && mb_strlen($ratecategory) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($ratecategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratecategory) && mb_strlen($ratecategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\ROOM_2
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get persontype value
     * @return string
     */
    public function getPersontype()
    {
        return $this->persontype;
    }
    /**
     * Set persontype value
     * @param string $persontype
     * @return \StructType\ROOM_2
     */
    public function setPersontype($persontype = null)
    {
        // validation for constraint: string
        if (!is_null($persontype) && !is_string($persontype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($persontype, true), gettype($persontype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($persontype) && mb_strlen($persontype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($persontype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($persontype) && mb_strlen($persontype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($persontype)), __LINE__);
        }
        $this->persontype = $persontype;
        return $this;
    }
    /**
     * Get PERSON value
     * @return \StructType\PERSON_2[]|null
     */
    public function getPERSON()
    {
        return $this->PERSON;
    }
    /**
     * This method is responsible for validating the values passed to the setPERSON method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPERSON method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePERSONForArrayConstraintsFromSetPERSON(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rOOMPERSONItem) {
            // validation for constraint: itemType
            if (!$rOOMPERSONItem instanceof \StructType\PERSON_2) {
                $invalidValues[] = is_object($rOOMPERSONItem) ? get_class($rOOMPERSONItem) : sprintf('%s(%s)', gettype($rOOMPERSONItem), var_export($rOOMPERSONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PERSON property can only contain items of type \StructType\PERSON_2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PERSON value
     * @throws \InvalidArgumentException
     * @param \StructType\PERSON_2[] $pERSON
     * @return \StructType\ROOM_2
     */
    public function setPERSON(array $pERSON = array())
    {
        // validation for constraint: array
        if ('' !== ($pERSONArrayErrorMessage = self::validatePERSONForArrayConstraintsFromSetPERSON($pERSON))) {
            throw new \InvalidArgumentException($pERSONArrayErrorMessage, __LINE__);
        }
        $this->PERSON = $pERSON;
        return $this;
    }
    /**
     * Add item to PERSON value
     * @throws \InvalidArgumentException
     * @param \StructType\PERSON_2 $item
     * @return \StructType\ROOM_2
     */
    public function addToPERSON(\StructType\PERSON_2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PERSON_2) {
            throw new \InvalidArgumentException(sprintf('The PERSON property can only contain items of type \StructType\PERSON_2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PERSON[] = $item;
        return $this;
    }
}
