<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RESERVATION-SERVICE StructType
 * @subpackage Structs
 */
class RESERVATION_SERVICE extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The SERVICE_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SERVICE_OBJID;
    /**
     * Constructor method for RESERVATION-SERVICE
     * @uses RESERVATION_SERVICE::setRESERVATION_OBJID()
     * @uses RESERVATION_SERVICE::setSERVICE_OBJID()
     * @param string $rESERVATION_OBJID
     * @param string $sERVICE_OBJID
     */
    public function __construct($rESERVATION_OBJID = null, $sERVICE_OBJID = null)
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setSERVICE_OBJID($sERVICE_OBJID);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\RESERVATION_SERVICE
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get SERVICE_OBJID value
     * @return string
     */
    public function getSERVICE_OBJID()
    {
        return $this->{'SERVICE-OBJID'};
    }
    /**
     * Set SERVICE_OBJID value
     * @param string $sERVICE_OBJID
     * @return \StructType\RESERVATION_SERVICE
     */
    public function setSERVICE_OBJID($sERVICE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICE_OBJID) && !is_string($sERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICE_OBJID, true), gettype($sERVICE_OBJID)), __LINE__);
        }
        $this->SERVICE_OBJID = $this->{'SERVICE-OBJID'} = $sERVICE_OBJID;
        return $this;
    }
}
